# Simple CRM - Sistema CRM Modular y Funcional

## 🚀 Descripción

Simple CRM es una versión completamente rediseñada y simplificada del sistema ProfixCRM. Eliminando la complejidad innecesaria, APIs complejas y problemas de inter-módulos, este sistema ofrece todas las funcionalidades esenciales de un CRM de forma simple y eficiente.

## ✨ Características Principales

- **Sistema Modular Simple**: Cada módulo es independiente y funcional
- **Sin APIs Complejas**: Comunicación directa con la base de datos
- **Interfaz Web Responsive**: Diseño moderno y funcional
- **Autenticación Segura**: Sistema de login con sesiones PHP
- **Base de Datos Optimizada**: Esquema simple y eficiente

## 📋 Módulos Incluidos

### 🏠 Dashboard
- Estadísticas en tiempo real
- Resumen de leads, usuarios y escritorios
- Actividades recientes

### 👥 Gestión de Usuarios
- Crear, editar y eliminar usuarios
- Sistema de roles y permisos
- Control de acceso por módulos

### 📊 Gestión de Leads
- CRUD completo de leads
- Asignación a usuarios y escritorios
- Seguimiento de estados y actividades
- Filtros y búsqueda avanzada

### 🏢 Gestión de Escritorios
- Organización por equipos/áreas
- Asignación de managers
- Control de horarios de trabajo
- Estadísticas por escritorio

## 🛠️ Instalación

### Requisitos
- PHP 8.0 o superior
- MySQL/MariaDB 5.7 o superior
- Servidor web (Apache/Nginx) o PHP built-in server

### Pasos de Instalación

1. **Clonar/Copiar archivos**
   ```bash
   # Los archivos ya están en: c:\xampp\htdocs\profixcrm\simple_crm\
   ```

2. **Configurar Base de Datos**
   ```bash
   # Ejecutar el esquema SQL
   mysql -u root < database/schema.sql
   ```

3. **Configurar Conexión**
   - Editar `database/config.php` con tus credenciales de BD

4. **Iniciar Servidor**
   ```bash
   # Servidor PHP built-in
   php -S localhost:8080 -t simple_crm
   
   # O usar XAMPP/Apache apuntando al directorio simple_crm
   ```

## 🔐 Credenciales por Defecto

- **Usuario**: admin
- **Contraseña**: password
- **Email**: admin@simplecrm.com

## 📁 Estructura del Proyecto

```
simple_crm/
├── index.php              # Punto de entrada principal
├── database/
│   ├── config.php         # Configuración de BD
│   ├── connection.php     # Clase de conexión PDO
│   └── schema.sql         # Esquema de base de datos
├── modules/
│   ├── auth/              # Autenticación
│   ├── dashboard/         # Panel principal
│   ├── leads/             # Gestión de leads
│   ├── users/             # Gestión de usuarios
│   ├── desks/             # Gestión de escritorios
│   └── shared/            # Componentes compartidos
└── public/
    ├── style.css          # Estilos CSS
    └── script.js          # JavaScript frontend
```

## 🔧 Configuración

### Base de Datos
Editar `database/config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'simple_crm');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### Aplicación
```php
define('APP_NAME', 'Simple CRM');
define('APP_VERSION', '1.0.0');
define('TIMEZONE', 'America/Mexico_City');
```

## 🚀 Uso

### Acceso al Sistema
1. Navegar a `http://localhost:8080`
2. Iniciar sesión con las credenciales por defecto
3. Explorar los módulos desde el menú de navegación

### Gestión de Leads
1. Ir a **Leads** → **Nuevo Lead**
2. Completar la información del lead
3. Asignar a usuario y escritorio
4. Hacer seguimiento desde el listado

### Gestión de Usuarios
1. Ir a **Usuarios** → **Nuevo Usuario**
2. Crear usuario con roles apropiados
3. Asignar a escritorios según sea necesario

### Gestión de Escritorios
1. Ir a **Escritorios** → **Nuevo Escritorio**
2. Configurar manager y horarios
3. Asignar usuarios al escritorio

## 🔒 Seguridad

- Contraseñas hasheadas con `password_hash()`
- Validación de sesiones en cada página
- Protección contra inyección SQL con PDO
- Validación de entrada en formularios

## 📊 Base de Datos

### Tablas Principales
- `users` - Usuarios del sistema
- `roles` - Roles y permisos
- `leads` - Información de leads
- `desks` - Escritorios/equipos
- `lead_activities` - Actividades y seguimiento

## 🐛 Solución de Problemas

### Error de Conexión a BD
- Verificar credenciales en `database/config.php`
- Asegurar que MySQL/MariaDB esté ejecutándose
- Verificar que la base de datos `simple_crm` exista

### Error 404 en Módulos
- Verificar que el servidor esté apuntando al directorio correcto
- Revisar permisos de archivos

### Problemas de Login
- Verificar que el usuario `admin` exista en la BD
- Resetear contraseña si es necesario

## 🔄 Migración desde Sistema Anterior

Si tienes datos del sistema anterior:
1. Exportar datos importantes
2. Adaptar formato a las nuevas tablas
3. Importar usando scripts SQL personalizados

## 📈 Próximas Mejoras

- [ ] Exportación de reportes
- [ ] Notificaciones por email
- [ ] API REST opcional
- [ ] Integración con herramientas externas
- [ ] Dashboard más avanzado

## 🤝 Soporte

Para soporte técnico o consultas:
- Revisar logs del servidor web
- Verificar logs de PHP
- Consultar documentación de módulos específicos

---

**Simple CRM v1.0.0** - Sistema CRM modular, simple y funcional