-- Script para actualizar el esquema existente
-- Agregar nuevas columnas a la tabla roles si no existen

ALTER TABLE roles 
ADD COLUMN IF NOT EXISTS description TEXT,
ADD COLUMN IF NOT EXISTS is_system BOOLEAN DEFAULT FALSE,
ADD COLUMN IF NOT EXISTS is_active BOOLEAN DEFAULT TRUE,
ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

-- Agregar nuevas columnas a la tabla permissions si no existen
ALTER TABLE permissions 
ADD COLUMN IF NOT EXISTS description TEXT,
ADD COLUMN IF NOT EXISTS module VARCHAR(50) NOT NULL DEFAULT 'general',
ADD COLUMN IF NOT EXISTS action VARCHAR(50) NOT NULL DEFAULT 'view',
ADD COLUMN IF NOT EXISTS is_system BOOLEAN DEFAULT FALSE,
ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;

-- Agregar índice si no existe
ALTER TABLE permissions ADD INDEX IF NOT EXISTS idx_module_action (module, action);

-- Actualizar roles existentes para marcarlos como del sistema
UPDATE roles SET is_system = TRUE WHERE name IN ('admin', 'user', 'manager');
UPDATE roles SET is_active = TRUE WHERE is_active IS NULL;

-- Actualizaciones de tabla leads (agregar columnas faltantes si no existen)
ALTER TABLE leads 
ADD COLUMN IF NOT EXISTS city VARCHAR(100) NULL AFTER country;

ALTER TABLE leads 
ADD COLUMN IF NOT EXISTS investment_amount DECIMAL(15,2) DEFAULT 0.00 AFTER trading_experience;

-- Asegurar que el rol Admin tenga TODOS los permisos (incluidos nuevos)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT (SELECT id FROM roles WHERE name = 'admin' LIMIT 1), p.id FROM permissions p;