<?php
/**
 * ProfixCRM Simple - Sistema CRM Modular y Funcional
 * Archivo principal de entrada
 */

// Iniciar sesión
session_start();

// Configuración básica
define('BASE_PATH', __DIR__);
define('MODULES_PATH', BASE_PATH . '/modules');
define('PUBLIC_PATH', BASE_PATH . '/public');

// Incluir configuración de base de datos
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

// Verificar si el usuario está logueado
function isLoggedIn() {
    return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']);
}

// Obtener módulo y acción de la URL
$module = $_GET['module'] ?? 'dashboard';
$action = $_GET['action'] ?? 'index';

// Si no está logueado y no está en login, redirigir
if (!isLoggedIn() && $module !== 'auth') {
    $module = 'auth';
    $action = 'login';
}

// Cargar el módulo solicitado
$module_file = MODULES_PATH . '/' . $module . '/' . $action . '.php';

if (file_exists($module_file)) {
    include $module_file;
} else {
    // Página 404
    http_response_code(404);
    echo "<h1>Página no encontrada</h1>";
    echo "<p>El módulo '$module' o la acción '$action' no existe.</p>";
    echo "<a href='?module=dashboard'>Volver al Dashboard</a>";
}
?>