<?php
/**
 * Módulo Leads - Endpoint AJAX para agregar actividad (llamada, email, reunión, tarea, nota)
 */

header('Content-Type: application/json; charset=utf-8');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado']);
    exit;
}

$db = getDB();

$lead_id = intval($_POST['lead_id'] ?? 0);
$type = strtolower(trim($_POST['type'] ?? ''));
$subject = trim($_POST['subject'] ?? '');
$description = trim($_POST['description'] ?? '');
$scheduled_at = trim($_POST['scheduled_at'] ?? '');
$status = trim($_POST['status'] ?? '');

if ($lead_id <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'lead_id inválido']);
    exit;
}

$allowed_types = ['call','email','meeting','task','note','system'];
if (!in_array($type, $allowed_types, true)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'Tipo inválido']);
    exit;
}

if ($subject === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'El asunto es obligatorio']);
    exit;
}

// Validar existencia del lead
$lead = $db->selectOne('SELECT id FROM leads WHERE id = ?', [$lead_id]);
if (!$lead) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Lead no encontrado']);
    exit;
}

// Determinar estado por defecto si no se envía
if ($status === '') {
    if (in_array($type, ['meeting','task'], true) && $scheduled_at !== '') {
        $status = 'pending';
    } else {
        $status = 'completed';
    }
}

try {
    // Insertar actividad
    $sql = "INSERT INTO lead_activities (lead_id, type, subject, description, status, scheduled_at, created_by, created_at)
            VALUES (?, ?, ?, ?, ?, ?, ?, NOW())";
    $db->execute($sql, [
        $lead_id,
        $type,
        $subject,
        $description,
        $status,
        ($scheduled_at !== '' ? $scheduled_at : null),
        $_SESSION['user_id']
    ]);

    // Actualizaciones en leads
    $updates = [
        'updated_at = NOW()',
        'last_seen = NOW()'
    ];
    $params = [$lead_id];

    // Si es nota, actualizar cache de última nota
    if ($type === 'note') {
        $db->execute("UPDATE leads SET last_note = ?, last_note_at = NOW(), updated_at = NOW(), last_seen = NOW() WHERE id = ?", [$description, $lead_id]);
    } else {
        $db->execute("UPDATE leads SET updated_at = NOW(), last_seen = NOW() WHERE id = ?", [$lead_id]);
    }

    // Datos para respuesta
    $user = $db->selectOne('SELECT username, CONCAT(first_name, " ", last_name) AS name FROM users WHERE id = ?', [$_SESSION['user_id']]);
    $nowRow = $db->selectOne('SELECT NOW() AS now');

    echo json_encode([
        'ok' => true,
        'message' => 'Actividad registrada',
        'activity' => [
            'created_at' => $nowRow['now'] ?? date('Y-m-d H:i:s'),
            'type' => $type,
            'subject' => $subject,
            'description' => $description,
            'status' => $status,
            'scheduled_at' => $scheduled_at ?: null,
            'creator_username' => $user['username'] ?? '',
            'creator_name' => $user['name'] ?? ''
        ]
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Error al registrar la actividad']);
}
?>