<?php
/**
 * Módulo Leads - Endpoint AJAX para agregar nota a un lead
 */

header('Content-Type: application/json; charset=utf-8');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado']);
    exit;
}

$db = getDB();

$lead_id = intval($_POST['lead_id'] ?? 0);
$subject = trim($_POST['subject'] ?? '');
$description = trim($_POST['description'] ?? '');

if ($lead_id <= 0) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'lead_id inválido']);
    exit;
}

if ($subject === '') {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => 'El asunto es obligatorio']);
    exit;
}

// Validar existencia del lead
$lead = $db->selectOne('SELECT id FROM leads WHERE id = ?', [$lead_id]);
if (!$lead) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Lead no encontrado']);
    exit;
}

try {
    $db->execute(
        "INSERT INTO lead_activities (lead_id, type, subject, description, status, created_by, created_at)
         VALUES (?, 'note', ?, ?, 'completed', ?, NOW())",
        [$lead_id, $subject, $description, $_SESSION['user_id']]
    );
    // Actualizar cache en leads, última actualización y última interacción
    $db->execute(
        "UPDATE leads SET last_note = ?, last_note_at = NOW(), updated_at = NOW(), last_seen = NOW() WHERE id = ?",
        [$description, $lead_id]
    );
    // Datos para respuesta
    $user = $db->selectOne('SELECT username, CONCAT(first_name, " ", last_name) AS name FROM users WHERE id = ?', [$_SESSION['user_id']]);
    $nowRow = $db->selectOne('SELECT NOW() AS now');

    echo json_encode([
        'ok' => true,
        'message' => 'Nota agregada',
        'activity' => [
            'created_at' => $nowRow['now'] ?? date('Y-m-d H:i:s'),
            'type' => 'note',
            'subject' => $subject,
            'description' => $description,
            'creator_username' => $user['username'] ?? '',
            'creator_name' => $user['name'] ?? ''
        ]
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['ok' => false, 'error' => 'Error al guardar la nota']);
}
?>