<?php
/**
 * Módulo Leads - Perfil del Lead
 */

$current_module = 'leads';

if (!isLoggedIn()) {
    header('Location: ?module=auth&action=login');
    exit;
}

$db = getDB();
$lead_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($lead_id <= 0) {
    header('Location: ?module=leads');
    exit;
}

// Obtener datos del lead
$lead = $db->selectOne(
    "SELECT l.*, 
            l.job_title AS position,
            u.username AS assigned_user,
            CONCAT(u.first_name, ' ', u.last_name) AS assigned_name,
            d.name AS desk_name
     FROM leads l
     LEFT JOIN users u ON l.assigned_to = u.id
     LEFT JOIN desks d ON l.desk_id = d.id
     WHERE l.id = ?",
    [$lead_id]
);

if (!$lead) {
    header('Location: ?module=leads');
    exit;
}

// Actividades recientes del lead
$activities = $db->select(
    "SELECT la.*, u.username AS creator_username, CONCAT(u.first_name, ' ', u.last_name) AS creator_name
     FROM lead_activities la
     LEFT JOIN users u ON la.created_by = u.id
     WHERE la.lead_id = ?
     ORDER BY la.created_at DESC
     LIMIT 20",
    [$lead_id]
);

// Configuración del layout
$page_title = 'Perfil del Lead';
$module = 'leads';
$action = 'view';
$content_file = BASE_PATH . '/modules/leads/view_content.php';

include BASE_PATH . '/modules/shared/layout.php';
?>