<?php
// Helpers para badges
function statusBadgeClasses($status) {
    $map = [
        'new' => 'bg-blue-100 text-blue-800',
        'contacted' => 'bg-yellow-100 text-yellow-800',
        'qualified' => 'bg-green-100 text-green-800',
        'demo_scheduled' => 'bg-purple-100 text-purple-800',
        'demo_completed' => 'bg-indigo-100 text-indigo-800',
        'deposit_pending' => 'bg-orange-100 text-orange-800',
        'deposited' => 'bg-emerald-100 text-emerald-800',
        'active_trader' => 'bg-teal-100 text-teal-800',
        'inactive' => 'bg-gray-100 text-gray-800',
        'closed_lost' => 'bg-red-100 text-red-800'
    ];
    return $map[$status] ?? 'bg-gray-100 text-gray-800';
}

function priorityBadgeClasses($priority) {
    $map = [
        'low' => 'bg-gray-100 text-gray-600',
        'medium' => 'bg-blue-100 text-blue-800',
        'high' => 'bg-orange-100 text-orange-800',
        'urgent' => 'bg-red-100 text-red-800'
    ];
    return $map[$priority] ?? 'bg-gray-100 text-gray-600';
}
?>

<?php 
    $is_online = (!empty($lead['last_seen']) && (time() - strtotime($lead['last_seen'])) <= 300);
    $full_name = trim(($lead['first_name'] ?? '') . ' ' . ($lead['last_name'] ?? ''));
    $preferred = @json_decode($lead['preferred_instruments'] ?? '[]', true);
    if (!is_array($preferred)) { $preferred = []; }
?>

<!-- Contexto del Lead para modales -->
<div id="lead-context" aria-hidden="true" style="display:none"
     data-id="<?php echo (int)$lead['id']; ?>"
     data-name="<?php echo htmlspecialchars($full_name ?: ''); ?>"
     data-email="<?php echo htmlspecialchars($lead['email'] ?? ''); ?>"
     data-phone="<?php echo htmlspecialchars($lead['phone'] ?? ''); ?>"
     data-company="<?php echo htmlspecialchars($lead['company'] ?? ''); ?>">
</div>

<section class="lead-hero premium">
    <div class="lead-hero-left">
        <div class="avatar-ring pulse">
            <div class="avatar-initials">
                <?php echo strtoupper(substr($lead['first_name'] ?? 'L', 0, 1) . substr($lead['last_name'] ?? 'D', 0, 1)); ?>
            </div>
        </div>
        <div class="lead-identity">
            <h1 class="lead-name title-gradient"><?php echo htmlspecialchars($full_name ?: 'Perfil del Lead'); ?></h1>
            <div class="lead-contact">
                <a class="contact-item" href="mailto:<?php echo htmlspecialchars($lead['email']); ?>">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M4 4h16v16H4z"/><path d="M22 6l-10 7L2 6"/></svg>
                    <?php echo htmlspecialchars($lead['email']); ?>
                </a>
                <?php if (!empty($lead['phone'])): ?>
                <a class="contact-item" href="tel:<?php echo htmlspecialchars($lead['phone']); ?>">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M22 16.92V21a2 2 0 01-2.18 2A19.86 19.86 0 013 5.18 2 2 0 015 3h4.09a2 2 0 012 1.72l.7 4.24a2 2 0 01-.57 1.94L9.91 12.09a16 16 0 006 6l1.19-1.31a2 2 0 011.94-.57l4.24.7a2 2 0 011.72 2z"/></svg>
                    <?php echo htmlspecialchars($lead['phone']); ?>
                </a>
                <?php endif; ?>
            </div>
            <div class="lead-flags">
                <span class="badge <?php echo statusBadgeClasses($lead['status']); ?>"><?php echo htmlspecialchars($lead['status']); ?></span>
                <span class="badge <?php echo priorityBadgeClasses($lead['priority']); ?>">Prioridad: <?php echo htmlspecialchars($lead['priority']); ?></span>
                <span class="badge <?php echo $is_online ? 'bg-emerald-100 text-emerald-800' : 'bg-gray-100 text-gray-800'; ?>">
                    <span class="dot <?php echo $is_online ? 'dot-online' : 'dot-offline'; ?>"></span>
                    <?php echo $is_online ? 'Online' : 'Offline'; ?>
                </span>
            </div>
        </div>
    </div>
    <div class="lead-hero-right">
        <div class="quick-actions">
            <button class="qa-btn" onclick="quickActivity(<?php echo $lead['id']; ?>, 'call')">
                <span class="qa-icon">📞</span>
                Llamada
            </button>
            <button class="qa-btn" onclick="quickActivity(<?php echo $lead['id']; ?>, 'email')">
                <span class="qa-icon">✉️</span>
                Email
            </button>
            <button class="qa-btn" onclick="quickActivity(<?php echo $lead['id']; ?>, 'meeting')">
                <span class="qa-icon">🎥</span>
                Demo
            </button>
            <button class="qa-btn" onclick="quickActivity(<?php echo $lead['id']; ?>, 'task')">
                <span class="qa-icon">✅</span>
                Tarea
            </button>
            <button class="qa-btn" onclick="addNote(<?php echo $lead['id']; ?>)">
                <span class="qa-icon">📝</span>
                Nota
            </button>
        </div>
        <div class="hero-actions">
            <a href="?module=leads&action=edit&id=<?php echo $lead['id']; ?>" class="btn-primary">Editar</a>
            <a href="?module=leads" class="btn-secondary">Volver</a>
        </div>
    </div>
</section>

<section class="lead-panels premium">
    <div class="panel panel-elevated panel-premium">
        <h3 class="panel-title"><span class="panel-icon">ℹ️</span> Información del Lead</h3>
        <div class="info-grid">
            <div class="text-muted">Nombre</div>
            <div>
                <div class="identity-row">
                    <span class="id-icon">👤</span>
                    <span class="id-text"><?php echo htmlspecialchars($lead['first_name'] . ' ' . $lead['last_name']); ?></span>
                    <?php if (!empty($lead['country'])): ?>
                        <span class="tag"><?php echo htmlspecialchars($lead['country']); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="text-muted">Email</div>
            <div>
                <div class="contact-row">
                    <a class="email-link" href="mailto:<?php echo htmlspecialchars($lead['email']); ?>"><?php echo htmlspecialchars($lead['email']); ?></a>
                    <button class="chip" onclick="copyToClipboard('<?php echo htmlspecialchars($lead['email']); ?>')">Copiar</button>
                </div>
            </div>

            <div class="text-muted">Teléfono</div>
            <div>
                <div class="contact-row">
                    <a class="phone-link" href="tel:<?php echo htmlspecialchars($lead['phone']); ?>"><?php echo htmlspecialchars($lead['phone']); ?></a>
                    <button class="chip" onclick="copyToClipboard('<?php echo htmlspecialchars($lead['phone']); ?>')">Copiar</button>
                </div>
            </div>

            <div class="text-muted">Empresa</div>
            <div>
                <div class="identity-row">
                    <span class="id-icon">🏢</span>
                    <span class="id-text"><?php echo htmlspecialchars($lead['company'] ?? ''); ?></span>
                </div>
            </div>

            <div class="text-muted">Cargo</div>
            <div>
                <div class="identity-row">
                    <span class="id-icon">💼</span>
                    <span class="id-text"><?php echo htmlspecialchars($lead['position'] ?? ''); ?></span>
                </div>
            </div>

            <div class="text-muted">Fuente</div>
            <div>
                <div class="identity-row">
                    <span class="id-icon">🧭</span>
                    <span class="id-text"><?php echo htmlspecialchars($lead['source'] ?? ''); ?></span>
                </div>
            </div>

            <div class="text-muted">Última actualización</div>
            <div>
                <span class="meta-pill"><?php echo htmlspecialchars($lead['updated_at'] ?? $lead['created_at']); ?></span>
            </div>

            <div class="text-muted">Última nota</div>
            <div>
                <div class="note-box"><?php echo nl2br(htmlspecialchars($lead['last_note'] ?? '')); ?></div>
            </div>
        </div>
    </div>
    <div class="panel panel-elevated panel-premium">
        <h3 class="panel-title"><span class="panel-icon">👥</span> Asignación y Estado</h3>
        <div class="info-grid wide">
            <div class="text-muted">Asignado a</div>
            <div>
                <div class="assign-row">
                    <div class="assigned-avatar">
                        <?php $initial = strtoupper(substr(($lead['assigned_name'] ?? $lead['assigned_user'] ?? 'U'), 0, 1)); ?>
                        <span class="assigned-initial"><?php echo $initial; ?></span>
                    </div>
                    <div class="assigned-meta">
                        <div class="assigned-name"><?php echo htmlspecialchars($lead['assigned_name'] ?: ($lead['assigned_user'] ?? 'Sin asignar')); ?></div>
                        <div class="assigned-desk"><?php echo htmlspecialchars($lead['desk_name'] ?? ''); ?></div>
                    </div>
                </div>
            </div>

            <div class="text-muted">Estado</div>
            <div>
                <?php $allowed_statuses = ['new','contacted','qualified','demo_scheduled','demo_completed','deposit_pending','deposited','active_trader','inactive','closed_lost']; ?>
                <div class="status-row">
                    <select id="lead-status-select" data-lead-id="<?php echo (int)$lead['id']; ?>" class="filter-select" style="min-width:240px;">
                        <?php foreach($allowed_statuses as $st): ?>
                            <option value="<?php echo $st; ?>" <?php echo ($lead['status']===$st)?'selected':''; ?>><?php echo $st; ?></option>
                        <?php endforeach; ?>
                    </select>
                    <span id="lead-status-saving" class="saving-pill" style="display:none;">
                        <span class="spinner"></span>
                        Guardando...
                    </span>
                    <span id="lead-status-badge" class="status-badge <?php echo statusBadgeClasses($lead['status']); ?>"><?php echo htmlspecialchars($lead['status']); ?></span>
                </div>
            </div>

            <div class="text-muted">Prioridad</div>
            <div>
                <span class="priority-pill <?php echo priorityBadgeClasses($lead['priority']); ?>"><?php echo htmlspecialchars($lead['priority']); ?></span>
            </div>

            <div class="text-muted">Creado</div>
            <div><span class="meta-pill"><?php echo htmlspecialchars($lead['created_at']); ?></span></div>

            <div class="text-muted">Última vista</div>
            <div><span class="meta-pill"><?php echo htmlspecialchars($lead['last_seen'] ?? '-'); ?></span></div>
        </div>
    </div>
</section>

<section class="kpi-grid">
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">📊</span>
            <span class="kpi-title">Experiencia</span>
        </div>
        <div class="kpi-value"><?php echo htmlspecialchars($lead['trading_experience'] ?? 'none'); ?></div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">💰</span>
            <span class="kpi-title">Inversión</span>
        </div>
        <div class="kpi-value">$<?php echo number_format((float)($lead['investment_amount'] ?? 0), 2); ?></div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">⚖️</span>
            <span class="kpi-title">Riesgo</span>
        </div>
        <div class="kpi-value"><?php echo htmlspecialchars($lead['risk_tolerance'] ?? 'medium'); ?></div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">🧪</span>
            <span class="kpi-title">Tipo de cuenta</span>
        </div>
        <div class="kpi-value"><?php echo htmlspecialchars($lead['account_type'] ?? 'demo'); ?></div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">🏦</span>
            <span class="kpi-title">Depósito</span>
        </div>
        <div class="kpi-value"><?php echo htmlspecialchars(($lead['deposit_currency'] ?? 'USD') . ' ' . number_format((float)($lead['deposit_amount'] ?? 0), 2)); ?></div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">🎯</span>
            <span class="kpi-title">Prob. Conversión</span>
        </div>
        <div class="kpi-value">
            <div class="progress">
                <div class="progress-bar" style="width: <?php echo max(0, min(100, (int)($lead['conversion_probability'] ?? 0))); ?>%"></div>
            </div>
            <span><?php echo (int)($lead['conversion_probability'] ?? 0); ?>%</span>
        </div>
    </div>
    <div class="kpi-card">
        <div class="kpi-header">
            <span class="kpi-icon">⭐</span>
            <span class="kpi-title">Lead Score</span>
        </div>
        <div class="kpi-value">
            <div class="progress">
                <div class="progress-bar alt" style="width: <?php echo max(0, min(100, (int)($lead['lead_score'] ?? 0) / 10)); ?>%"></div>
            </div>
            <span><?php echo (int)($lead['lead_score'] ?? 0); ?></span>
        </div>
    </div>
</section>

<section class="instruments-panel">
    <h3 class="panel-title">Instrumentos preferidos</h3>
    <div class="instrument-tags">
        <?php if (empty($preferred)): ?>
            <span class="tag">Sin datos</span>
        <?php else: foreach ($preferred as $instr): ?>
            <span class="tag fade-in"><?php echo htmlspecialchars($instr); ?></span>
        <?php endforeach; endif; ?>
    </div>
</section>

<div class="card timeline-card">
    <div class="card-header d-flex justify-between align-center">
        <h3 class="card-title">Actividad reciente</h3>
    </div>
    <div class="card-body">
        <?php if (empty($activities)): ?>
            <div class="alert alert-info">No hay actividad registrada para este lead.</div>
        <?php else: ?>
            <ul class="timeline">
                <?php foreach ($activities as $act): ?>
                    <li class="timeline-item fade-in">
                        <span class="timeline-dot"></span>
                        <div class="timeline-content">
                            <div class="timeline-header">
                                <span class="timeline-type">
                                    <?php 
                                    $icons = ['call' => '📞','email' => '✉️','meeting' => '🎥','note' => '📝','task' => '✅','system' => '⚙️'];
                                    echo $icons[$act['type']] ?? '📌';
                                    ?>
                                    <?php echo htmlspecialchars($act['type']); ?>
                                </span>
                                <span class="timeline-date"><?php echo htmlspecialchars($act['created_at']); ?></span>
                            </div>
                            <div class="timeline-subject"><?php echo htmlspecialchars($act['subject']); ?></div>
                            <div class="timeline-desc"><?php echo htmlspecialchars($act['description']); ?></div>
                            <div class="timeline-meta">por <?php echo htmlspecialchars($act['creator_name'] ?: $act['creator_username']); ?></div>
                        </div>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </div>
</div>