<?php
/**
 * Layout principal del CRM con sidebar
 */

if (!isLoggedIn()) {
    // Redirigir SIEMPRE al index raíz para evitar bucles cuando se accede directamente a archivos en /modules
    header('Location: ../../index.php?module=auth&action=login');
    exit;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' . APP_NAME : APP_NAME; ?></title>
    <link rel="stylesheet" href="/simple_crm/public/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="crm-layout">
    <?php include BASE_PATH . '/modules/shared/sidebar.php'; ?>
    
    <div class="main-wrapper">
        <header class="top-header">
            <div class="header-left">
                <button class="mobile-menu-btn" id="mobileMenuBtn">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 12h18M3 6h18M3 18h18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                </button>
                <div class="breadcrumb">
                    <span class="breadcrumb-item"><?php echo ucfirst($module ?? 'Dashboard'); ?></span>
                    <?php if (isset($action) && $action !== 'index'): ?>
                        <span class="breadcrumb-separator">/</span>
                        <span class="breadcrumb-item"><?php echo ucfirst($action); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            
            <div class="header-right">
                <div class="header-actions">
                    <button class="header-btn" id="notificationsBtn" title="Notificaciones">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10 2a6 6 0 016 6c0 7 3 9 3 9H1s3-2 3-9a6 6 0 016-6zM8.5 17h3a1.5 1.5 0 01-3 0z" stroke="currentColor" stroke-width="2" fill="none"/>
                        </svg>
                        <span class="notification-badge">3</span>
                    </button>
                    
                    <button class="header-btn" id="searchBtn" title="Buscar">
                        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M19 19l-4-4m0-7A7 7 0 11-1 8a7 7 0 0114 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </button>
                </div>
                
                <div class="user-dropdown">
                    <button class="user-dropdown-btn" id="userDropdownBtn">
                        <div class="user-avatar-small">
                            <?php echo strtoupper(substr($_SESSION['user_name'] ?? 'U', 0, 1)); ?>
                        </div>
                        <span class="user-name-header"><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'Usuario'); ?></span>
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4 6l4 4 4-4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </button>
                    
                    <div class="user-dropdown-menu" id="userDropdownMenu">
                        <a href="#" class="dropdown-item">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8 8a3 3 0 100-6 3 3 0 000 6zm0 0a6.5 6.5 0 00-6.5 6.5.5.5 0 001 0A5.5 5.5 0 018 9a5.5 5.5 0 015.5 5.5.5.5 0 001 0A6.5 6.5 0 008 8z" fill="currentColor"/>
                            </svg>
                            Mi Perfil
                        </a>
                        <a href="#" class="dropdown-item">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M8 1a7 7 0 100 14A7 7 0 008 1zM7 11V9h2v2H7zM7 7V5h2v2H7z" fill="currentColor"/>
                            </svg>
                            Ayuda
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="?module=auth&action=logout" class="dropdown-item text-danger">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6 15H2a1 1 0 01-1-1V2a1 1 0 011-1h4m5 4l3 3-3 3m3-3H7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            Cerrar Sesión
                        </a>
                    </div>
                </div>
            </div>
        </header>
        
        <main class="main-content">
            <div class="content-wrapper">
                <?php 
                // Renderizar contenido del módulo
                if (isset($content)) {
                    echo $content; // contenido capturado vía ob_start/ob_get_clean
                } elseif (isset($content_file) && file_exists($content_file)) {
                    include $content_file; // archivo de contenido específico
                } else {
                    echo '<div class="error-message">Contenido no encontrado</div>';
                }
                ?>
            </div>
        </main>
    </div>
    
    <!-- Scripts -->
    <script src="/simple_crm/public/script.js"></script>
    <script>
        // Funcionalidad del sidebar
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');
            const sidebarToggle = document.getElementById('sidebarToggle');
            const mobileMenuBtn = document.getElementById('mobileMenuBtn');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const userDropdownBtn = document.getElementById('userDropdownBtn');
            const userDropdownMenu = document.getElementById('userDropdownMenu');
            
            // Toggle sidebar en desktop
            if (sidebarToggle) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('collapsed');
                    localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
                });
            }
            
            // Toggle sidebar en mobile
            if (mobileMenuBtn) {
                mobileMenuBtn.addEventListener('click', function() {
                    sidebar.classList.toggle('mobile-open');
                    sidebarOverlay.classList.toggle('active');
                });
            }
            
            // Cerrar sidebar en mobile al hacer click en overlay
            if (sidebarOverlay) {
                sidebarOverlay.addEventListener('click', function() {
                    sidebar.classList.remove('mobile-open');
                    sidebarOverlay.classList.remove('active');
                });
            }
            
            // Dropdown de usuario
            if (userDropdownBtn && userDropdownMenu) {
                userDropdownBtn.addEventListener('click', function(e) {
                    e.stopPropagation();
                    userDropdownMenu.classList.toggle('show');
                });
                
                document.addEventListener('click', function() {
                    userDropdownMenu.classList.remove('show');
                });
            }
            
            // Restaurar estado del sidebar
            if (localStorage.getItem('sidebarCollapsed') === 'true') {
                sidebar.classList.add('collapsed');
            }
        });
        
        // Función para cambiar tema
        function toggleTheme() {
            document.body.classList.toggle('dark-theme');
            localStorage.setItem('darkTheme', document.body.classList.contains('dark-theme'));
        }
        
        // Restaurar tema
        if (localStorage.getItem('darkTheme') === 'true') {
            document.body.classList.add('dark-theme');
        }
    </script>
</body>
</html>