<?php
/**
 * Sidebar compartido para todas las páginas del CRM
 */
// Asegurar que $current_module esté definido para evitar warnings
if (!isset($current_module)) {
    $current_module = $_GET['module'] ?? 'dashboard';
}

// Helpers de permisos para visibilidad de menú
if (!function_exists('getDB')) {
    require_once BASE_PATH . '/database/connection.php';
}
$pdo = getDB()->getConnection();
$current_user_id = $_SESSION['user_id'] ?? null;

if (!function_exists('userHasPermissionByName')) {
    function userHasPermissionByName($pdo, $permName, $userId) {
        if (empty($userId)) return false;
        $stmt = $pdo->prepare("SELECT 1 FROM role_permissions rp INNER JOIN permissions p ON rp.permission_id = p.id INNER JOIN user_roles ur ON rp.role_id = ur.role_id WHERE ur.user_id = ? AND p.name = ? LIMIT 1");
        $stmt->execute([$userId, $permName]);
        return (bool)$stmt->fetchColumn();
    }
}
?>

<aside class="sidebar">
    <div class="sidebar-header">
        <div class="logo">
            <div class="logo-icon">
                <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="32" height="32" rx="8" fill="#1e40af"/>
                    <path d="M8 12h16v2H8v-2zm0 4h16v2H8v-2zm0 4h12v2H8v-2z" fill="white"/>
                </svg>
            </div>
            <div class="logo-text">
                <span class="logo-title">ProfixCRM</span>
                <span class="logo-subtitle">Business Suite</span>
            </div>
        </div>
    </div>

    <nav class="sidebar-nav">
        <ul class="nav-list">
            <?php if (userHasPermissionByName($pdo, 'menu.dashboard.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=dashboard" class="nav-link <?php echo ($current_module == 'dashboard') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="3" y="3" width="7" height="7"/>
                            <rect x="14" y="3" width="7" height="7"/>
                            <rect x="14" y="14" width="7" height="7"/>
                            <rect x="3" y="14" width="7" height="7"/>
                        </svg>
                    </div>
                    <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.leads.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=leads" class="nav-link <?php echo ($current_module == 'leads') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="m22 2-5 10-5-5-5 10"/>
                        </svg>
                    </div>
                    <span class="nav-text">Leads</span>
                    <?php if (isset($leads_count) && $leads_count > 0): ?>
                        <span class="nav-badge"><?php echo $leads_count; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.desks.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=desks" class="nav-link <?php echo ($current_module == 'desks') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"/>
                            <line x1="8" y1="21" x2="16" y2="21"/>
                            <line x1="12" y1="17" x2="12" y2="21"/>
                        </svg>
                    </div>
                    <span class="nav-text">Desks</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.users.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=users" class="nav-link <?php echo ($current_module == 'users') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="12" cy="7" r="4"/>
                        </svg>
                    </div>
                    <span class="nav-text">Users</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.roles.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=roles" class="nav-link <?php echo ($current_module == 'roles') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <span class="nav-text">Roles y Permisos</span>
                </a>
            </li>
            <?php endif; ?>
            
            <div class="nav-divider"></div>
            
            <?php if (userHasPermissionByName($pdo, 'menu.settings.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=settings" class="nav-link <?php echo ($current_module == 'settings') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="m12 1 2.09 6.26L22 9l-5.91 2.09L14 17l-2.09-5.91L4 9l5.91-2.09L12 1z"/>
                        </svg>
                    </div>
                    <span class="nav-text">Configuración</span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    </nav>

    <div class="sidebar-footer">
        <div class="user-profile">
            <div class="user-avatar">
                <div class="avatar-circle">
                    <?php echo strtoupper(substr($_SESSION['user_name'] ?? 'U', 0, 1)); ?>
                </div>
            </div>
            <div class="user-info">
                <div class="user-name"><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'Usuario'); ?></div>
                <div class="user-role">Administrador</div>
            </div>
        </div>
        
        <div class="logout-section">
            <a href="?module=auth&action=logout" class="logout-btn" title="Cerrar Sesión">
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7 17H2a2 2 0 01-2-2V3a2 2 0 012-2h5m6 4l4 4-4 4m4-4H9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </a>
        </div>
    </div>
</aside>