<?php
// Big4pay IPN - Notificación de estado de pagos
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
header('Content-Type: application/json; charset=utf-8');

try {
    $raw = file_get_contents('php://input');
    $json = json_decode($raw, true);
    // Fallback a POST/GET si no hay JSON
    if (!$json || !is_array($json)) {
        $json = $_POST ?: $_GET ?: [];
    }

    $event = [
        'received_at' => date('c'),
        'identifier' => $json['identifier'] ?? null,
        'status' => $json['status'] ?? ($json['payment_status'] ?? null),
        'transaction_id' => $json['transaction_id'] ?? null,
        'amount' => $json['amount'] ?? null,
        'currency' => $json['currency'] ?? null,
        'raw' => $json,
    ];

    // Guardar en archivo de log simple
    $dir = BASE_PATH . '/tmp';
    if (!is_dir($dir)) { @mkdir($dir, 0777, true); }
    $file = $dir . '/big4pay_ipn.log';
    @file_put_contents($file, json_encode($event) . PHP_EOL, FILE_APPEND | LOCK_EX);

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error IPN: ' . $e->getMessage()]);
}
?>