-- Crear tabla system_config para el módulo de configuración
-- Ejecutar este script para agregar la tabla de configuración del sistema

USE simple_crm;

CREATE TABLE IF NOT EXISTS system_config (
    id INT AUTO_INCREMENT PRIMARY KEY,
    config_key VARCHAR(100) NOT NULL UNIQUE,
    config_value TEXT NULL,
    description TEXT NULL,
    config_type ENUM('string', 'number', 'boolean', 'json') DEFAULT 'string',
    is_system BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_config_key (config_key),
    INDEX idx_config_type (config_type)
);

-- Insertar configuraciones por defecto
INSERT INTO system_config (config_key, config_value, description, config_type, is_system) VALUES
('company_name', 'ProfixCRM Business Suite', 'Nombre de la empresa', 'string', TRUE),
('company_logo', '', 'Archivo de logo de la empresa', 'string', FALSE),
('system_timezone', 'America/Mexico_City', 'Zona horaria del sistema', 'string', TRUE),
('system_currency', 'MXN', 'Moneda por defecto del sistema', 'string', TRUE),
('system_language', 'es', 'Idioma por defecto del sistema', 'string', TRUE),
('email_notifications', '1', 'Habilitar notificaciones por email', 'boolean', FALSE),
('maintenance_mode', '0', 'Modo de mantenimiento activado', 'boolean', FALSE),
('max_file_size', '10', 'Tamaño máximo de archivo en MB', 'number', FALSE),
('session_timeout', '3600', 'Tiempo de expiración de sesión en segundos', 'number', FALSE),
('backup_frequency', 'daily', 'Frecuencia de respaldos automáticos', 'string', FALSE),
('system_version', '1.0.0', 'Versión del sistema', 'string', TRUE),
('installation_date', NOW(), 'Fecha de instalación del sistema', 'string', TRUE),
('last_backup', '', 'Fecha del último respaldo', 'string', FALSE),
('smtp_host', '', 'Servidor SMTP para emails', 'string', FALSE),
('smtp_port', '587', 'Puerto SMTP', 'number', FALSE),
('smtp_username', '', 'Usuario SMTP', 'string', FALSE),
('smtp_password', '', 'Contraseña SMTP', 'string', FALSE),
('smtp_encryption', 'tls', 'Tipo de encriptación SMTP', 'string', FALSE),
('default_desk_id', '1', 'ID del escritorio por defecto', 'number', TRUE),
('password_min_length', '8', 'Longitud mínima de contraseña', 'number', FALSE),
('login_attempts_limit', '5', 'Límite de intentos de login fallidos', 'number', FALSE),
('auto_logout_time', '30', 'Tiempo de auto-logout por inactividad (minutos)', 'number', FALSE)
ON DUPLICATE KEY UPDATE 
    config_value = VALUES(config_value),
    updated_at = CURRENT_TIMESTAMP;