-- Seed inicial de permisos del sistema
-- Este archivo debe ejecutarse después de crear las tablas

-- Limpiar datos existentes (solo en desarrollo)
-- DELETE FROM role_permissions;
-- DELETE FROM user_roles WHERE role_id > 3;
-- DELETE FROM permissions WHERE is_system = FALSE;
-- DELETE FROM roles WHERE is_system = FALSE;

-- Insertar roles del sistema
INSERT IGNORE INTO roles (name, display_name, description, is_system, is_active) VALUES
('admin', 'Administrador', 'Acceso completo al sistema', TRUE, TRUE),
('manager', 'Gerente', 'Gestión de equipos y reportes', TRUE, TRUE),
('user', 'Usuario', 'Acceso básico al sistema', TRUE, TRUE),
('sales_rep', 'Representante de Ventas', 'Gestión de leads y oportunidades', FALSE, TRUE),
('marketing', 'Marketing', 'Gestión de campañas y contenido', FALSE, TRUE);

-- Permisos del módulo de Usuarios
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('users.view', 'Ver Usuarios', 'Permite ver la lista de usuarios', 'users', 'view', TRUE),
('users.create', 'Crear Usuarios', 'Permite crear nuevos usuarios', 'users', 'create', TRUE),
('users.edit', 'Editar Usuarios', 'Permite editar información de usuarios', 'users', 'edit', TRUE),
('users.delete', 'Eliminar Usuarios', 'Permite eliminar usuarios del sistema', 'users', 'delete', TRUE),
('users.manage_roles', 'Gestionar Roles de Usuario', 'Permite asignar y remover roles', 'users', 'manage_roles', TRUE);

-- Permisos del módulo de Leads
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('leads.view', 'Ver Leads', 'Permite ver la lista de leads', 'leads', 'view', TRUE),
('leads.view_all', 'Ver Todos los Leads', 'Permite ver leads de todos los usuarios', 'leads', 'view_all', TRUE),
('leads.create', 'Crear Leads', 'Permite crear nuevos leads', 'leads', 'create', TRUE),
('leads.edit', 'Editar Leads', 'Permite editar información de leads', 'leads', 'edit', TRUE),
('leads.edit_all', 'Editar Todos los Leads', 'Permite editar leads de cualquier usuario', 'leads', 'edit_all', TRUE),
('leads.delete', 'Eliminar Leads', 'Permite eliminar leads', 'leads', 'delete', TRUE),
('leads.assign', 'Asignar Leads', 'Permite asignar leads a otros usuarios', 'leads', 'assign', TRUE),
('leads.export', 'Exportar Leads', 'Permite exportar datos de leads', 'leads', 'export', TRUE),
('leads.import', 'Importar Leads', 'Permite importar leads masivamente', 'leads', 'import', TRUE);

-- Permisos sensibles de Leads (visualización completa de email/teléfono)
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('leads.view_email_full', 'Ver Email Completo', 'Permite ver el email del lead sin enmascarar', 'leads', 'view_email_full', TRUE),
('leads.view_phone_full', 'Ver Teléfono Completo', 'Permite ver el teléfono del lead sin enmascarar', 'leads', 'view_phone_full', TRUE);

-- Permisos del módulo de Clientes
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('clients.view', 'Ver Clientes', 'Permite ver la lista de clientes', 'clients', 'view', TRUE),
('clients.create', 'Crear Clientes', 'Permite crear nuevos clientes', 'clients', 'create', TRUE),
('clients.edit', 'Editar Clientes', 'Permite editar información de clientes', 'clients', 'edit', TRUE),
('clients.delete', 'Eliminar Clientes', 'Permite eliminar clientes', 'clients', 'delete', TRUE);

-- Permisos sensibles de Clientes (visualización completa de email/teléfono)
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('clients.view_email_full', 'Ver Email Completo (Clientes)', 'Permite ver el email del cliente sin enmascarar', 'clients', 'view_email_full', TRUE),
('clients.view_phone_full', 'Ver Teléfono Completo (Clientes)', 'Permite ver el teléfono del cliente sin enmascarar', 'clients', 'view_phone_full', TRUE);

-- Permisos de máscara solicitados (nomenclatura personalizada)
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('lead_email_mask', 'Ver Email Completo (Leads)', 'Permite ver el email del lead sin enmascarar', 'leads', 'mask_email', TRUE),
('lead_number_mask', 'Ver Teléfono Completo (Leads)', 'Permite ver el teléfono del lead sin enmascarar', 'leads', 'mask_phone', TRUE);

INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('client_email_mask', 'Ver Email Completo (Clientes)', 'Permite ver el email del cliente sin enmascarar', 'clients', 'mask_email', TRUE),
('client_number_mask', 'Ver Teléfono Completo (Clientes)', 'Permite ver el teléfono del cliente sin enmascarar', 'clients', 'mask_phone', TRUE);

-- Permisos del módulo de Actividades
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('activities.view', 'Ver Actividades', 'Permite ver actividades propias', 'activities', 'view', TRUE),
('activities.view_all', 'Ver Todas las Actividades', 'Permite ver actividades de todos los usuarios', 'activities', 'view_all', TRUE),
('activities.create', 'Crear Actividades', 'Permite crear nuevas actividades', 'activities', 'create', TRUE),
('activities.edit', 'Editar Actividades', 'Permite editar actividades propias', 'activities', 'edit', TRUE),
('activities.edit_all', 'Editar Todas las Actividades', 'Permite editar actividades de cualquier usuario', 'activities', 'edit_all', TRUE),
('activities.delete', 'Eliminar Actividades', 'Permite eliminar actividades', 'activities', 'delete', TRUE);

-- Permisos del módulo de Reportes
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('reports.view', 'Ver Reportes', 'Permite ver reportes básicos', 'reports', 'view', TRUE),
('reports.advanced', 'Reportes Avanzados', 'Permite acceder a reportes avanzados', 'reports', 'advanced', TRUE),
('reports.export', 'Exportar Reportes', 'Permite exportar reportes', 'reports', 'export', TRUE),
('reports.create', 'Crear Reportes', 'Permite crear reportes personalizados', 'reports', 'create', TRUE);

-- Permisos del módulo de Configuración
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('settings.view', 'Ver Configuración', 'Permite ver configuraciones del sistema', 'settings', 'view', TRUE),
('settings.edit', 'Editar Configuración', 'Permite modificar configuraciones', 'settings', 'edit', TRUE),
('settings.system', 'Configuración del Sistema', 'Permite acceder a configuraciones críticas', 'settings', 'system', TRUE);

-- Permisos del módulo de Roles y Permisos
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('roles.view', 'Ver Roles', 'Permite ver la lista de roles', 'roles', 'view', TRUE),
('roles.create', 'Crear Roles', 'Permite crear nuevos roles', 'roles', 'create', TRUE),
('roles.edit', 'Editar Roles', 'Permite editar roles existentes', 'roles', 'edit', TRUE),
('roles.delete', 'Eliminar Roles', 'Permite eliminar roles no críticos', 'roles', 'delete', TRUE),
('roles.assign', 'Asignar Roles', 'Permite asignar roles a usuarios', 'roles', 'assign', TRUE),
('permissions.view', 'Ver Permisos', 'Permite ver la lista de permisos', 'permissions', 'view', TRUE),
('permissions.manage', 'Gestionar Permisos', 'Permite gestionar permisos de roles', 'permissions', 'manage', TRUE);

-- Permisos del módulo de Dashboard
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('dashboard.view', 'Ver Dashboard', 'Permite acceder al dashboard principal', 'dashboard', 'view', TRUE),
('dashboard.analytics', 'Ver Analytics', 'Permite ver métricas y análisis avanzados', 'dashboard', 'analytics', TRUE);

-- Permisos de Menú (visibilidad de items en la barra lateral)
INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system) VALUES
('menu.dashboard.view', 'Ver Menú Dashboard', 'Permite ver el ítem de Dashboard en el menú', 'menu', 'dashboard.view', TRUE),
('menu.leads.view', 'Ver Menú Leads', 'Permite ver el ítem de Leads en el menú', 'menu', 'leads.view', TRUE),
('menu.activities.view', 'Ver Menú Actividades', 'Permite ver el ítem de Actividades en el menú', 'menu', 'activities.view', TRUE),
('menu.reports.view', 'Ver Menú Reportes', 'Permite ver el ítem de Reportes en el menú', 'menu', 'reports.view', TRUE),
('menu.users.view', 'Ver Menú Usuarios', 'Permite ver el ítem de Usuarios en el menú', 'menu', 'users.view', TRUE),
('menu.roles.view', 'Ver Menú Roles', 'Permite ver el ítem de Roles y Permisos en el menú', 'menu', 'roles.view', TRUE),
('menu.settings.view', 'Ver Menú Configuración', 'Permite ver el ítem de Configuración en el menú', 'menu', 'settings.view', TRUE),
('menu.desks.view', 'Ver Menú Desks', 'Permite ver el ítem de Desks en el menú', 'menu', 'desks.view', TRUE);

-- Asignar permisos a roles del sistema

-- Rol Admin: Todos los permisos
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT 1, id FROM permissions;

-- Rol Manager: Permisos de gestión (sin configuración del sistema)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT 2, id FROM permissions 
WHERE name NOT IN ('settings.system', 'users.delete', 'roles.delete');

-- Rol User: Permisos básicos
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT 3, id FROM permissions 
WHERE name IN (
    'dashboard.view',
    'menu.dashboard.view',
    'menu.leads.view',
    'menu.activities.view',
    'menu.reports.view',
    'leads.view', 'leads.create', 'leads.edit',
    'activities.view', 'activities.create', 'activities.edit',
    'reports.view'
);

-- Rol Sales Rep: Permisos de ventas
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT 4, id FROM permissions 
WHERE name IN (
    'dashboard.view', 'dashboard.analytics',
    'menu.dashboard.view', 'menu.leads.view', 'menu.activities.view', 'menu.reports.view',
    'leads.view', 'leads.create', 'leads.edit', 'leads.export',
    'activities.view', 'activities.create', 'activities.edit',
    'reports.view', 'reports.export'
);

-- Rol Marketing: Permisos de marketing
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT 5, id FROM permissions 
WHERE name IN (
    'dashboard.view', 'dashboard.analytics',
    'menu.dashboard.view', 'menu.leads.view', 'menu.activities.view', 'menu.reports.view',
    'leads.view', 'leads.view_all', 'leads.create', 'leads.import', 'leads.export',
    'activities.view', 'activities.view_all',
    'reports.view', 'reports.advanced', 'reports.export', 'reports.create'
);

-- Asignar rol admin al usuario con ID 1 (si existe)
INSERT IGNORE INTO user_roles (user_id, role_id, assigned_at)
SELECT 1, 1, NOW()
WHERE EXISTS (SELECT 1 FROM users WHERE id = 1);