-- Ejecutar después de crear el esquema (schema.sql)

-- Usuarios de ejemplo (contraseña "password")
INSERT INTO users (username, email, first_name, last_name, password_hash, status, created_at)
VALUES 
  ('manager1', 'manager1@example.com', 'Laura', 'Gómez', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'active', NOW()),
  ('agent1', 'agent1@example.com', 'Carlos', 'Ramírez', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'active', NOW()),
  ('agent2', 'agent2@example.com', 'María', 'Fernández', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'active', NOW());

-- Asignar roles
INSERT INTO user_roles (user_id, role_id)
SELECT u.id, r.id FROM users u JOIN roles r ON r.name = 'manager' WHERE u.username = 'manager1';
INSERT INTO user_roles (user_id, role_id)
SELECT u.id, r.id FROM users u JOIN roles r ON r.name = 'agent' WHERE u.username = 'agent1';
INSERT INTO user_roles (user_id, role_id)
SELECT u.id, r.id FROM users u JOIN roles r ON r.name = 'agent' WHERE u.username = 'agent2';
INSERT INTO user_roles (user_id, role_id)
SELECT u.id, r.id FROM users u JOIN roles r ON r.name = 'admin' WHERE u.username = 'admin';

INSERT INTO desks (name, description, manager_id, status, created_at)
VALUES
  ('Sales', 'Escritorio de ventas general', (SELECT id FROM users WHERE username='manager1'), 'active', NOW()),
  ('VIP', 'Gestión de clientes VIP y high net worth', (SELECT id FROM users WHERE username='manager1'), 'active', NOW()),
  ('LATAM', 'Mercados Latinoamérica', (SELECT id FROM users WHERE username='manager1'), 'active', NOW());

-- Asignación de usuarios a escritorios
INSERT INTO desk_users (desk_id, user_id)
SELECT (SELECT id FROM desks WHERE name='Sales'), id FROM users WHERE username IN ('agent1','agent2');
INSERT INTO desk_users (desk_id, user_id)
SELECT (SELECT id FROM desks WHERE name='LATAM'), id FROM users WHERE username IN ('agent2');

-- Leads de ejemplo
INSERT INTO leads (
  first_name, last_name, email, phone, company, job_title, source,
  status, priority, assigned_to, desk_id, notes, created_at
) VALUES
  ('Jane', 'Doe', 'jane.doe@example.com', '+34 611 111 111', 'TechSoft', 'Analista', 'website',
   'new', 'medium', (SELECT id FROM users WHERE username='agent1'), (SELECT id FROM desks WHERE name='Sales'), 'Interesada en cuenta demo', NOW()),
  ('John', 'Smith', 'john.smith@example.com', '+34 622 222 222', 'FinCorp', 'Contable', 'facebook',
   'contacted', 'high', (SELECT id FROM users WHERE username='agent2'), (SELECT id FROM desks WHERE name='LATAM'), 'Solicitó más info sobre CFDs', NOW() - INTERVAL 5 DAY),
  ('Ana', 'Pérez', 'ana.perez@example.com', '+57 300 123 4567', 'RetailCo', 'Gerente', 'google_ads',
   'qualified', 'high', (SELECT id FROM users WHERE username='agent1'), (SELECT id FROM desks WHERE name='LATAM'), 'Busca cuenta VIP', NOW() - INTERVAL 20 DAY),
  ('Luis', 'Rodríguez', 'luis.rod@example.com', '+34 633 333 333', 'AutoParts', 'Ventas', 'referral',
   'demo_scheduled', 'medium', (SELECT id FROM users WHERE username='agent2'), (SELECT id FROM desks WHERE name='Sales'), 'Pendiente de demo', NOW() - INTERVAL 8 DAY),
  ('Maria', 'Lopez', 'maria.lopez@example.com', '+34 644 444 444', 'EduTech', 'Profesora', 'instagram',
   'closed_lost', 'low', (SELECT id FROM users WHERE username='agent1'), (SELECT id FROM desks WHERE name='Sales'), 'No disponible por ahora', NOW() - INTERVAL 12 DAY),
  ('Carlos', 'Santana', 'c.santana@example.com', '+34 655 555 555', 'Logis SA', 'Operaciones', 'website',
   'deposited', 'high', (SELECT id FROM users WHERE username='agent2'), (SELECT id FROM desks WHERE name='VIP'), 'Depósito inicial realizado', NOW() - INTERVAL 30 DAY),
  ('Sofía', 'Martínez', 'sofia.mtz@example.com', '+34 666 666 666', 'MarketingPro', 'CMO', 'linkedin',
   'demo_scheduled', 'medium', (SELECT id FROM users WHERE username='agent1'), (SELECT id FROM desks WHERE name='VIP'), 'Muy interesada en cuentas gestionadas', NOW() - INTERVAL 40 DAY),
  ('Diego', 'Suarez', 'diego.suarez@example.com', '+34 677 777 777', 'TravelCo', 'Agente', 'twitter',
   'inactive', 'low', (SELECT id FROM users WHERE username='agent2'), (SELECT id FROM desks WHERE name='Sales'), 'No responde correos', NOW() - INTERVAL 65 DAY);

INSERT INTO lead_activities (lead_id, type, subject, description, status, scheduled_at, completed_at, created_by, created_at)
VALUES 
  ((SELECT id FROM leads WHERE email='jane.doe@example.com'), 'note', 'Lead creado', 'Lead creado desde el sitio web. Interesada en cuenta demo.', 'completed', NULL, NOW(), (SELECT id FROM users WHERE username='agent1'), NOW()),
  ((SELECT id FROM leads WHERE email='john.smith@example.com'), 'call', 'Seguimiento', 'Llamada de seguimiento. Próxima reunión en 3 días.', 'completed', NOW() - INTERVAL 2 DAY, NOW() - INTERVAL 1 DAY, (SELECT id FROM users WHERE username='agent2'), NOW() - INTERVAL 1 DAY),
  ((SELECT id FROM leads WHERE email='ana.perez@example.com'), 'note', 'Calificación VIP', 'Cliente calificado para cuenta VIP. Requiere asesoramiento.', 'completed', NULL, NOW() - INTERVAL 2 DAY, (SELECT id FROM users WHERE username='manager1'), NOW() - INTERVAL 2 DAY);