<?php
/**
 * Actualizador de esquema: aplica update_schema.sql sobre la BD actual.
 */
if (!defined('BASE_PATH')) {
    define('BASE_PATH', dirname(__DIR__));
}
require_once BASE_PATH . '/database/config.php';

// Conectar a la BD seleccionada
$dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
try {
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false
    ]);
} catch (PDOException $e) {
    fwrite(STDERR, "Error de conexión: " . $e->getMessage() . "\n");
    exit(1);
}

$path = BASE_PATH . '/database/update_schema.sql';
if (!file_exists($path)) {
    fwrite(STDERR, "No se encontró update_schema.sql en $path\n");
    exit(1);
}
$sql = file_get_contents($path);

// Ejecutar en lotes por ';'
$clean = preg_replace('/^\s*--.*$/m', '', $sql);
$stmts = array_filter(array_map('trim', explode(';', $clean)), function($s){ return $s !== ''; });
$count = 0;
foreach ($stmts as $stmt) {
    $pdo->exec($stmt);
    $count++;
}
echo "Actualización aplicada. Sentencias ejecutadas: $count\n";
?>