<?php
session_start();
require_once 'database/config.php';
require_once 'database/connection.php';

echo "<h2>Debug Leads Check</h2>";

// Verificar sesión
echo "<h3>Sesión:</h3>";
echo "Session ID: " . session_id() . "<br>";
echo "User ID: " . ($_SESSION['user_id'] ?? 'No definido') . "<br>";
echo "Logged in: " . (isset($_SESSION['user_id']) ? 'Sí' : 'No') . "<br><br>";

// Verificar conexión a BD
try {
    $db = getDB();
    echo "<h3>Base de Datos:</h3>";
    echo "Conexión: OK<br><br>";
    
    // Listar leads
    echo "<h3>Leads en la base de datos:</h3>";
    $leads = $db->select("SELECT id, first_name, last_name, email FROM leads ORDER BY id LIMIT 10");
    
    if ($leads) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Nombre</th><th>Email</th><th>Link Test</th></tr>";
        foreach ($leads as $lead) {
            echo "<tr>";
            echo "<td>" . $lead['id'] . "</td>";
            echo "<td>" . htmlspecialchars($lead['first_name'] . ' ' . $lead['last_name']) . "</td>";
            echo "<td>" . htmlspecialchars($lead['email']) . "</td>";
            echo "<td><a href='/modules/leads/view.php?id=" . $lead['id'] . "' target='_blank'>Ver Perfil</a></td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "No se encontraron leads.<br>";
    }
    
} catch (Exception $e) {
    echo "Error de conexión: " . $e->getMessage() . "<br>";
}
?>