<?php
echo "<h2>Debug View.php Detailed</h2>";

// Iniciar sesión
$started = false;
if (session_status() === PHP_SESSION_NONE) { 
    session_start(); 
    $started = true; 
    echo "Sesión iniciada: Sí<br>";
} else {
    echo "Sesión ya estaba iniciada<br>";
}

// Definir BASE_PATH
if (!defined('BASE_PATH')) { 
    define('BASE_PATH', dirname(dirname(__DIR__))); 
    echo "BASE_PATH definido: " . BASE_PATH . "<br>";
}

// Incluir archivos
echo "<h3>Incluyendo archivos...</h3>";
try {
    require_once BASE_PATH . '/database/config.php';
    echo "Config incluido: OK<br>";
} catch (Exception $e) {
    echo "Error config: " . $e->getMessage() . "<br>";
}

try {
    require_once BASE_PATH . '/database/connection.php';
    echo "Connection incluido: OK<br>";
} catch (Exception $e) {
    echo "Error connection: " . $e->getMessage() . "<br>";
}

// Función isLoggedIn
if (!function_exists('isLoggedIn')) {
    function isLoggedIn(){ return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']); }
    echo "Función isLoggedIn definida<br>";
}

echo "<h3>Verificaciones:</h3>";
echo "isLoggedIn(): " . (isLoggedIn() ? 'true' : 'false') . "<br>";
echo "Session user_id: " . ($_SESSION['user_id'] ?? 'No definido') . "<br>";

// Verificar parámetro ID
$lead_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
echo "Lead ID del parámetro: " . $lead_id . "<br>";

if ($lead_id <= 0) {
    echo "<strong>ERROR: Lead ID es 0 o negativo - se redirigiría a /modules/leads/index.php</strong><br>";
} else {
    echo "Lead ID válido: " . $lead_id . "<br>";
    
    // Intentar conectar a BD
    try {
        $db = getDB();
        echo "Conexión BD: OK<br>";
        
        // Buscar lead
        $lead = $db->selectOne(
            "SELECT l.*, 
                    l.job_title AS position,
                    u.username AS assigned_user,
                    CONCAT(u.first_name, ' ', u.last_name) AS assigned_name,
                    d.name AS desk_name,
                    d.color AS desk_color
             FROM leads l
             LEFT JOIN users u ON l.assigned_to = u.id
             LEFT JOIN desks d ON l.desk_id = d.id
             WHERE l.id = ?",
            [$lead_id]
        );
        
        if (!$lead) {
            echo "<strong>ERROR: Lead no encontrado en BD - se redirigiría a /modules/leads/index.php</strong><br>";
        } else {
            echo "Lead encontrado: " . htmlspecialchars($lead['first_name'] . ' ' . $lead['last_name']) . "<br>";
            echo "<strong>TODO OK - La página debería cargar correctamente</strong><br>";
        }
        
    } catch (Exception $e) {
        echo "Error BD: " . $e->getMessage() . "<br>";
    }
}

echo "<h3>URLs de prueba:</h3>";
echo "<a href='/modules/leads/view.php?id=1'>Test Lead ID 1</a><br>";
echo "<a href='/modules/leads/view.php?id=2'>Test Lead ID 2</a><br>";
echo "<a href='/modules/leads/view.php?id=999'>Test Lead ID 999 (no existe)</a><br>";
?>