<?php
/**
 * Script para corregir paths incorrectos de CSS y JS
 * Corrige paths como:
 * - /test/simple_crm/public/style.css -> ../../public/style.css (relativo)
 * - /public/script.js -> ../../public/script.js (relativo)
 */

echo "<h1>🔧 Corrección de Paths CSS y JS</h1>\n";
echo "<p>Iniciando corrección de paths incorrectos...</p>\n";

// Archivos a corregir basados en la búsqueda
$files_to_fix = [
    'modules/desks/create.php',
    'modules/desks/index.php', 
    'modules/leads/create.php',
    'modules/client_portal/tickets.php',
    'modules/client_portal/layout.php',
    'modules/client_portal/login.php',
    'modules/shared/layout.php',
    'modules/client_portal/ticket.php',
    'modules/desks/edit.php',
    'modules/desks/ticket.php',
    'modules/auth/login.php',
    'modules/client_portal/documents.php',
    'modules/users/create.php',
    'modules/users/index.php',
    'modules/desks/document_review.php'
];

$corrections_made = 0;
$total_files = 0;

foreach ($files_to_fix as $file_path) {
    $full_path = __DIR__ . '/' . $file_path;
    
    if (!file_exists($full_path)) {
        echo "<p>⚠️ Archivo no encontrado: $file_path</p>\n";
        continue;
    }
    
    $content = file_get_contents($full_path);
    $original_content = $content;
    $file_corrections = 0;
    
    // Determinar la profundidad del directorio para calcular el path relativo correcto
    $depth = substr_count($file_path, '/');
    $relative_prefix = str_repeat('../', $depth);
    
    // Correcciones específicas
    $corrections = [
        // CSS paths incorrectos
        '/test/simple_crm/public/style.css' => $relative_prefix . 'public/style.css',
        '"/test/simple_crm/public/style.css"' => '"' . $relative_prefix . 'public/style.css"',
        "'/test/simple_crm/public/style.css'" => "'" . $relative_prefix . 'public/style.css' . "'",
        
        // JS paths incorrectos
        '/public/script.js' => $relative_prefix . 'public/script.js',
        '"/public/script.js"' => '"' . $relative_prefix . 'public/script.js"',
        "'/public/script.js'" => "'" . $relative_prefix . 'public/script.js' . "'",
    ];
    
    foreach ($corrections as $search => $replace) {
        if (strpos($content, $search) !== false) {
            $content = str_replace($search, $replace, $content);
            $file_corrections++;
            echo "<p>✅ Corregido en $file_path: <code>$search</code> → <code>$replace</code></p>\n";
        }
    }
    
    // Guardar archivo si hubo cambios
    if ($content !== $original_content) {
        file_put_contents($full_path, $content);
        $corrections_made += $file_corrections;
        $total_files++;
        echo "<p><strong>📁 Archivo actualizado: $file_path ($file_corrections correcciones)</strong></p>\n";
    } else {
        echo "<p>ℹ️ Sin cambios necesarios en: $file_path</p>\n";
    }
}

echo "<hr>\n";
echo "<h2>📊 Resumen de Correcciones</h2>\n";
echo "<ul>\n";
echo "<li><strong>Archivos procesados:</strong> " . count($files_to_fix) . "</li>\n";
echo "<li><strong>Archivos modificados:</strong> $total_files</li>\n";
echo "<li><strong>Correcciones totales:</strong> $corrections_made</li>\n";
echo "</ul>\n";

if ($corrections_made > 0) {
    echo "<div style='background-color: #d4edda; padding: 15px; border-radius: 5px; margin: 20px 0;'>\n";
    echo "<h3>✅ Correcciones Completadas</h3>\n";
    echo "<p>Se han corregido todos los paths incorrectos de CSS y JS. Los archivos ahora usan paths relativos correctos.</p>\n";
    echo "<p><strong>Tipos de correcciones realizadas:</strong></p>\n";
    echo "<ul>\n";
    echo "<li><code>/test/simple_crm/public/style.css</code> → <code>../../public/style.css</code> (o similar según profundidad)</li>\n";
    echo "<li><code>/public/script.js</code> → <code>../../public/script.js</code> (o similar según profundidad)</li>\n";
    echo "</ul>\n";
    echo "</div>\n";
} else {
    echo "<div style='background-color: #fff3cd; padding: 15px; border-radius: 5px; margin: 20px 0;'>\n";
    echo "<h3>ℹ️ No se Necesitaron Correcciones</h3>\n";
    echo "<p>Todos los paths ya están correctos o no se encontraron los patrones esperados.</p>\n";
    echo "</div>\n";
}

echo "<p><a href='test_edit_role_authenticated.php'>🔄 Volver a probar el módulo de roles</a></p>\n";
?>