<?php
/**
 * Script para corregir rutas de CSS para el entorno de producción
 * Entorno: public_html/test/simple_crm
 */

// Archivos que necesitan corrección para producción
$files_to_fix = [
    'modules/shared/layout.php',
    'modules/client_portal/documents.php',
    'modules/desks/index.php',
    'modules/desks/ticket.php',
    'modules/desks/create.php',
    'modules/users/index.php',
    'modules/client_portal/login.php',
    'modules/auth/login.php',
    'modules/client_portal/ticket.php',
    'modules/leads/create.php',
    'modules/desks/edit.php',
    'modules/client_portal/tickets.php',
    'modules/client_portal/layout.php',
    'modules/users/create.php',
    'modules/desks/document_review.php'
];

echo "<h1>Corrigiendo rutas de CSS para Producción</h1>";
echo "<p>Entorno: public_html/test/simple_crm</p>";
echo "<hr>";

foreach ($files_to_fix as $file) {
    $full_path = __DIR__ . '/' . $file;
    
    if (file_exists($full_path)) {
        $content = file_get_contents($full_path);
        $original_content = $content;
        
        // Para producción, usar rutas absolutas desde la raíz del dominio
        $production_path = '/test/simple_crm/public/';
        
        // Reemplazar rutas relativas con rutas absolutas de producción
        $content = preg_replace('/href="\.\.\/\.\.\/public\//', 'href="' . $production_path, $content);
        $content = preg_replace('/href="\.\.\/public\//', 'href="' . $production_path, $content);
        $content = preg_replace('/href="public\//', 'href="' . $production_path, $content);
        
        // También corregir rutas de JavaScript si las hay
        $content = preg_replace('/src="\.\.\/\.\.\/public\//', 'src="' . $production_path, $content);
        $content = preg_replace('/src="\.\.\/public\//', 'src="' . $production_path, $content);
        $content = preg_replace('/src="public\//', 'src="' . $production_path, $content);
        
        if ($content !== $original_content) {
            if (file_put_contents($full_path, $content)) {
                echo "✓ Corregido: $file<br>";
                echo "&nbsp;&nbsp;→ Ruta de producción: $production_path<br>";
            } else {
                echo "✗ Error al corregir: $file<br>";
            }
        } else {
            echo "- Sin cambios: $file<br>";
        }
    } else {
        echo "✗ Archivo no encontrado: $file<br>";
    }
}

echo "<br><h2>Configuración adicional</h2>";

// Crear archivo de configuración para producción
$config_content = '<?php
/**
 * Configuración específica para producción
 * Entorno: public_html/test/simple_crm
 */

// Rutas base para producción
if (!defined("PRODUCTION_BASE_URL")) define("PRODUCTION_BASE_URL", "/test/simple_crm");
if (!defined("PRODUCTION_PUBLIC_PATH")) define("PRODUCTION_PUBLIC_PATH", "/test/simple_crm/public");

// Función helper para generar rutas de assets
function asset_url($path) {
    return PRODUCTION_PUBLIC_PATH . "/" . ltrim($path, "/");
}

// Función helper para generar rutas del sistema
function system_url($path = "") {
    return PRODUCTION_BASE_URL . "/" . ltrim($path, "/");
}
?>';

if (file_put_contents(__DIR__ . '/config_production_paths.php', $config_content)) {
    echo "✓ Creado archivo de configuración: config_production_paths.php<br>";
}

echo "<br><h2>Corrección completada</h2>";
echo "<p>Las rutas han sido ajustadas para el entorno de producción:</p>";
echo "<ul>";
echo "<li><strong>Ruta base:</strong> /test/simple_crm</li>";
echo "<li><strong>Archivos públicos:</strong> /test/simple_crm/public/</li>";
echo "<li><strong>CSS:</strong> /test/simple_crm/public/style.css</li>";
echo "</ul>";

echo "<p><strong>Próximos pasos:</strong></p>";
echo "<ol>";
echo "<li>Sube todos los archivos al servidor de producción</li>";
echo "<li>Asegúrate de que la estructura de directorios sea: public_html/test/simple_crm/</li>";
echo "<li>Verifica que los archivos CSS estén en: public_html/test/simple_crm/public/</li>";
echo "</ol>";

echo "<p><a href='index.php'>Probar el sistema</a></p>";
?>