<?php
/**
 * Script para regenerar los hashes de contraseña correctamente
 */

require_once 'database/connection.php';

echo "<h2>Regeneración de contraseñas de usuarios</h2>";

try {
    $db = getDB();
    
    // Verificar usuarios existentes
    echo "<h3>1. Usuarios actuales:</h3>";
    $users = $db->select("SELECT id, username, email, status FROM users");
    
    if (empty($users)) {
        echo "<p style='color: red;'>No hay usuarios en la base de datos. Ejecutando inicialización...</p>";
        
        // Ejecutar schema.sql
        $schema = file_get_contents('database/schema.sql');
        if ($schema) {
            $statements = explode(';', $schema);
            foreach ($statements as $statement) {
                $statement = trim($statement);
                if (!empty($statement)) {
                    try {
                        $db->execute($statement);
                    } catch (Exception $e) {
                        // Ignorar errores de tablas que ya existen
                        if (!strpos($e->getMessage(), 'already exists')) {
                            echo "<p style='color: orange;'>Advertencia: " . $e->getMessage() . "</p>";
                        }
                    }
                }
            }
        }
        
        // Ejecutar seed_sample_data.sql
        $seed = file_get_contents('database/seed_sample_data.sql');
        if ($seed) {
            $statements = explode(';', $seed);
            foreach ($statements as $statement) {
                $statement = trim($statement);
                if (!empty($statement)) {
                    try {
                        $db->execute($statement);
                    } catch (Exception $e) {
                        // Ignorar errores de duplicados
                        if (!strpos($e->getMessage(), 'Duplicate entry')) {
                            echo "<p style='color: orange;'>Advertencia: " . $e->getMessage() . "</p>";
                        }
                    }
                }
            }
        }
        
        echo "<p style='color: green;'>✓ Inicialización completada</p>";
        
        // Volver a obtener usuarios
        $users = $db->select("SELECT id, username, email, status FROM users");
    }
    
    if (!empty($users)) {
        echo "<table border='1' style='border-collapse: collapse;'>";
        echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Estado</th></tr>";
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>" . $user['id'] . "</td>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td>" . htmlspecialchars($user['status']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<h3>2. Regenerando hashes de contraseña:</h3>";
    
    // Lista de usuarios con sus contraseñas
    $user_passwords = [
        'admin' => 'password',
        'manager1' => 'password',
        'agent1' => 'password',
        'agent2' => 'password'
    ];
    
    foreach ($user_passwords as $username => $password) {
        // Generar nuevo hash
        $new_hash = password_hash($password, PASSWORD_DEFAULT);
        
        // Actualizar en la base de datos
        $result = $db->execute(
            "UPDATE users SET password_hash = ? WHERE username = ?",
            [$new_hash, $username]
        );
        
        if ($result) {
            echo "<p style='color: green;'>✓ Hash actualizado para: <strong>" . $username . "</strong></p>";
            
            // Verificar que el hash funciona
            if (password_verify($password, $new_hash)) {
                echo "<p style='color: green;'>  ✓ Verificación exitosa</p>";
            } else {
                echo "<p style='color: red;'>  ✗ Error en verificación</p>";
            }
        } else {
            echo "<p style='color: red;'>✗ Error actualizando: <strong>" . $username . "</strong></p>";
        }
    }
    
    echo "<h3>3. Verificación final:</h3>";
    echo "<p><strong>Credenciales disponibles:</strong></p>";
    echo "<ul>";
    foreach ($user_passwords as $username => $password) {
        $user = $db->selectOne(
            "SELECT id, username, email, status FROM users WHERE username = ?",
            [$username]
        );
        
        if ($user && $user['status'] === 'active') {
            echo "<li><strong>" . $username . "</strong> / " . $password . " - ✓ Activo</li>";
        } else {
            echo "<li><strong>" . $username . "</strong> / " . $password . " - ✗ No encontrado o inactivo</li>";
        }
    }
    echo "</ul>";
    
    echo "<hr>";
    echo "<h3 style='color: green;'>¡Listo! Ahora puedes usar estas credenciales para iniciar sesión:</h3>";
    echo "<p><strong>Usuario recomendado:</strong> admin</p>";
    echo "<p><strong>Contraseña:</strong> password</p>";
    
} catch (Exception $e) {
    echo "<h3 style='color: red;'>Error:</h3>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
    echo "<p>Trace: " . $e->getTraceAsString() . "</p>";
}
?>