<?php
// Layout principal para el Portal de Cliente, inspirado en el layout compartido del CRM
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['client_id'])) {
    header('Location: /modules/client_portal/login.php');
    exit;
}
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - Trader Room' : 'Trader Room'; ?></title>
    <link rel="stylesheet" href="/test/simple_crm/public/style.css">
    <link rel="stylesheet" href="/test/simple_crm/public/client_portal.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="crm-layout">
    <?php include __DIR__ . '/sidebar.php'; ?>
    <div id="sidebarOverlay" class="sidebar-overlay"></div>

    <div class="main-wrapper">
        <header class="top-header">
            <div class="header-left">
                <button class="mobile-menu-btn" id="mobileMenuBtn" aria-label="Abrir menú">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 12h18M3 6h18M3 18h18" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                    </svg>
                </button>
                <div class="breadcrumb">
                    <span class="breadcrumb-item"><?php echo ucfirst($module ?? 'Dashboard'); ?></span>
                    <?php if (isset($action) && $action !== 'index'): ?>
                        <span class="breadcrumb-separator">/</span>
                        <span class="breadcrumb-item"><?php echo ucfirst($action); ?></span>
                    <?php endif; ?>
                </div>
            </div>

            <div class="header-right">
                <div class="header-actions">
                    <button class="header-btn" title="Soporte" onclick="location.href='/modules/client_portal/tickets.php'">
                        <i class="fas fa-life-ring"></i>
                    </button>
                </div>

                <div class="user-dropdown">
                    <button class="user-dropdown-btn" id="userDropdownBtn">
                        <div class="user-avatar-small">
                            <?php echo strtoupper(substr($_SESSION['client_first_name'] ?? 'C', 0, 1)); ?>
                        </div>
                        <span class="user-name-header"><?php echo htmlspecialchars(($_SESSION['client_first_name'] ?? 'Cliente') . ' ' . ($_SESSION['client_last_name'] ?? '')); ?></span>
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M4 6l4 4 4-4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </button>

                    <div class="user-dropdown-menu" id="userDropdownMenu">
                        <a href="/modules/client_portal/documents.php" class="dropdown-item">
                            <i class="fas fa-file-lines"></i>
                            Mis Documentos
                        </a>
                        <a href="/modules/client_portal/tickets.php" class="dropdown-item">
                            <i class="fas fa-life-ring"></i>
                            Soporte
                        </a>
                        <div class="dropdown-divider"></div>
                        <a href="/modules/client_portal/logout.php" class="dropdown-item text-danger">
                            <i class="fas fa-arrow-right-from-bracket"></i>
                            Cerrar Sesión
                        </a>
                    </div>
                </div>
            </div>
        </header>

        <main class="main-content">
            <div class="content-wrapper">
                <?php 
                if (isset($content)) {
                    echo $content;
                } elseif (isset($content_file) && file_exists($content_file)) {
                    include $content_file;
                } else {
                    echo '<div class="error-message">Contenido no encontrado</div>';
                }
                ?>
            </div>
        </main>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('sidebar');
            const mobileMenuBtn = document.getElementById('mobileMenuBtn');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const userDropdownBtn = document.getElementById('userDropdownBtn');
            const userDropdownMenu = document.getElementById('userDropdownMenu');

            if (mobileMenuBtn) {
                mobileMenuBtn.addEventListener('click', function() {
                    if (sidebar) { sidebar.classList.toggle('mobile-open'); }
                    if (sidebarOverlay) { sidebarOverlay.classList.toggle('active'); }
                });
            }

            if (sidebarOverlay) {
                sidebarOverlay.addEventListener('click', function() {
                    if (sidebar) { sidebar.classList.remove('mobile-open'); }
                    sidebarOverlay.classList.remove('active');
                });
            }

            if (userDropdownBtn && userDropdownMenu) {
                userDropdownBtn.addEventListener('click', function(e) {
                    e.stopPropagation();
                    userDropdownMenu.classList.toggle('show');
                });
                document.addEventListener('click', function() {
                    userDropdownMenu.classList.remove('show');
                });
            }
        });
    </script>
</body>
</html>