<?php
/**
 * Sidebar del Client Portal con el mismo diseño del menú compartido
 * Usa las clases de style.css (.sidebar, .nav-list, .nav-link, etc.)
 */
// Preparar datos básicos del cliente
$clientName = ($_SESSION['client_first_name'] ?? '') . ' ' . ($_SESSION['client_last_name'] ?? '');
if (trim($clientName) === '') { $clientName = 'Cliente'; }

// Obtener gestor de cuentas asignado al cliente o su lead
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$manager = null;
try {
    $db = Database::getInstance();
    $pdo = $db->getConnection();
    $clientId = $_SESSION['client_id'] ?? null;
    if ($clientId) {
        $stmtC = $pdo->prepare('SELECT id, assigned_to, lead_id FROM clients WHERE id = ? LIMIT 1');
        $stmtC->execute([$clientId]);
        $clientRow = $stmtC->fetch();
        $assignedUserId = null;
        if ($clientRow) {
            if (!empty($clientRow['assigned_to'])) {
                $assignedUserId = (int)$clientRow['assigned_to'];
            } elseif (!empty($clientRow['lead_id'])) {
                $stmtL = $pdo->prepare('SELECT assigned_to FROM leads WHERE id = ? LIMIT 1');
                $stmtL->execute([$clientRow['lead_id']]);
                $assignedUserId = (int)$stmtL->fetchColumn();
            }
        }
        if ($assignedUserId) {
            $stmtU = $pdo->prepare('SELECT first_name, last_name, email FROM users WHERE id = ? LIMIT 1');
            $stmtU->execute([$assignedUserId]);
            $manager = $stmtU->fetch();
        }
    }
} catch (Throwable $e) {
    // Silenciar errores en sidebar para no romper la UI
}
?>

<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <a class="sidebar-logo" href="/modules/client_portal/dashboard.php">
            <div class="logo-icon">
                <svg width="28" height="28" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="32" height="32" rx="8" fill="#1e40af"/>
                    <path d="M8 12h16v2H8v-2zm0 4h16v2H8v-2zm0 4h12v2H8v-2z" fill="white"/>
                </svg>
            </div>
            <div class="logo-text">
                <?php
                // Obtener nombre de empresa dinámicamente
                $company_name = 'ProfixCRM'; // Valor por defecto
                
                try {
                    if (isset($pdo)) {
                        $stmt = $pdo->prepare("SELECT config_key, config_value FROM system_config WHERE config_key = 'company_name'");
                        $stmt->execute();
                        $config_item = $stmt->fetch(PDO::FETCH_ASSOC);
                        
                        if ($config_item && !empty($config_item['config_value'])) {
                            $company_name = $config_item['config_value'];
                        }
                    }
                } catch (Exception $e) {
                    // En caso de error, usar valor por defecto
                    $company_name = 'ProfixCRM';
                }
                ?>
                <div class="logo-title"><?php echo htmlspecialchars($company_name); ?></div>
                <div class="logo-subtitle">Trader Room</div>
            </div>
        </a>
    </div>

    <nav class="sidebar-nav">
        <ul class="nav-list">
            <li class="nav-item">
                <a href="/modules/client_portal/dashboard.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) === 'dashboard.php') ? 'active' : ''; ?>">
                    <div class="nav-icon"><i class="fas fa-house"></i></div>
                    <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/dashboard.php#accounts" class="nav-link">
                    <div class="nav-icon"><i class="fas fa-credit-card"></i></div>
                    <span class="nav-text">Cuentas</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/dashboard.php#deposits" class="nav-link">
                    <div class="nav-icon"><i class="fas fa-arrow-down"></i></div>
                    <span class="nav-text">Depósitos</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/dashboard.php#transactions" class="nav-link">
                    <div class="nav-icon"><i class="fas fa-arrows-left-right"></i></div>
                    <span class="nav-text">Transacciones</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/documents.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) === 'documents.php') ? 'active' : ''; ?>">
                    <div class="nav-icon"><i class="fas fa-file-lines"></i></div>
                    <span class="nav-text">Documentos</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/tickets.php" class="nav-link <?php echo (basename($_SERVER['PHP_SELF']) === 'tickets.php') ? 'active' : ''; ?>">
                    <div class="nav-icon"><i class="fas fa-life-ring"></i></div>
                    <span class="nav-text">Soporte</span>
                </a>
            </li>
            <li class="nav-item">
                <a href="/modules/client_portal/dashboard.php#settings" class="nav-link">
                    <div class="nav-icon"><i class="fas fa-gear"></i></div>
                    <span class="nav-text">Configuración</span>
                </a>
            </li>
        </ul>
    </nav>
    <?php if ($manager): ?>
    <div class="client-manager-card">
        <div class="client-manager-header">
            <div class="client-manager-avatar">
                <?php echo strtoupper(substr(trim(($manager['first_name'] ?? '')), 0, 1)); ?>
            </div>
            <div class="client-manager-info">
                <h4>Gestor de Cuentas</h4>
                <p><?php echo htmlspecialchars(($manager['first_name'] ?? '') . ' ' . ($manager['last_name'] ?? '')); ?></p>
            </div>
        </div>
        <div class="client-manager-contact">
            <a href="mailto:<?php echo htmlspecialchars($manager['email'] ?? ''); ?>" class="client-contact-btn">
                <i class="fas fa-envelope"></i>
                Contactar
            </a>
        </div>
    </div>
    <?php endif; ?>
</aside>