<?php
// Registrar depósito manual para cliente y transacción
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

function isLoggedIn(){ return isset($_SESSION['user_id']); }
if (!isLoggedIn()) { header('Location: /modules/auth/login.php'); exit; }

$client_id = isset($_POST['client_id']) ? intval($_POST['client_id']) : 0;
$amount = isset($_POST['amount']) ? floatval($_POST['amount']) : 0;
$currency = isset($_POST['currency']) ? trim($_POST['currency']) : 'USD';
$method = isset($_POST['method']) ? trim($_POST['method']) : 'manual';
$reference = isset($_POST['reference']) ? trim($_POST['reference']) : null;

if ($client_id <= 0 || $amount <= 0) { http_response_code(400); echo 'Datos inválidos'; exit; }

$db = Database::getInstance();
$pdo = $db->getConnection();

$pdo->beginTransaction();
try {
    // Insertar depósito
    $stmt = $pdo->prepare("INSERT INTO client_deposits (client_id, amount, currency, method, reference, status, created_at) VALUES (?,?,?,?,?,'confirmed',NOW())");
    $stmt->execute([$client_id, $amount, $currency, $method, $reference]);

    // Transacción
    $stmt2 = $pdo->prepare("INSERT INTO client_transactions (client_id, type, amount, currency, reference, notes, created_at) VALUES (?,?,?,?,?,'Depósito manual',NOW())");
    $stmt2->execute([$client_id, 'deposit', $amount, $currency, $reference]);

    $pdo->commit();
} catch (Exception $e) {
    $pdo->rollBack();
    http_response_code(500);
    echo 'Error al registrar depósito: ' . $e->getMessage();
    exit;
}

header('Location: /modules/clients/view.php?id=' . intval($client_id));
exit;
?>