<?php
/**
 * Script de instalación para Integraciones (tabla integration_settings).
 * Ejecutar:
 *   php modules/database/install_integrations.php
 */
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$db = getDB();
$pdo = $db->getConnection();

$sql = "
CREATE TABLE IF NOT EXISTS integration_settings (
  id INT AUTO_INCREMENT PRIMARY KEY,
  integration_name VARCHAR(50) NOT NULL,
  setting_key VARCHAR(100) NOT NULL,
  setting_value TEXT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE KEY unique_integration_setting (integration_name, setting_key)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
";

try {
  $pdo->exec($sql);
  echo "Tabla integration_settings creada/verificada.\n";
} catch (Exception $e) {
  echo "Error creando tabla: " . $e->getMessage() . "\n";
  exit(1);
}

echo "OK.\n";
?>