<?php
/**
 * Seed de permisos de máscara (lead/client *_mask) y asignación a Admin.
 * Ejecutar:
 *   php modules/database/seed_mask_permissions.php
 */

if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';

$db = getDB();
$pdo = $db->getConnection();

$perms = [
  ['lead_email_mask','Ver Email Completo (Leads)','Permite ver el email del lead sin enmascarar','leads','mask_email',1],
  ['lead_number_mask','Ver Teléfono Completo (Leads)','Permite ver el teléfono del lead sin enmascarar','leads','mask_phone',1],
  ['client_email_mask','Ver Email Completo (Clientes)','Permite ver el email del cliente sin enmascarar','clients','mask_email',1],
  ['client_number_mask','Ver Teléfono Completo (Clientes)','Permite ver el teléfono del cliente sin enmascarar','clients','mask_phone',1],
];

$insPerm = $pdo->prepare("INSERT IGNORE INTO permissions (name, display_name, description, module, action, is_system, updated_at) VALUES (?,?,?,?,?,?,NOW())");

foreach ($perms as $p) {
  $insPerm->execute($p);
}

// Asignar a rol admin si existe
$adminRoleId = null;
$stmt = $pdo->prepare("SELECT id FROM roles WHERE name = 'admin' LIMIT 1");
if ($stmt->execute() && ($row = $stmt->fetch())) { $adminRoleId = (int)$row['id']; }

if ($adminRoleId) {
  // Obtener IDs de permisos recién insertados
  $getPermId = $pdo->prepare("SELECT id FROM permissions WHERE name = ?");
  $insRolePerm = $pdo->prepare("INSERT IGNORE INTO role_permissions (role_id, permission_id, granted_at) VALUES (?,?,NOW())");
  foreach ($perms as $p) {
    $getPermId->execute([$p[0]]);
    $permRow = $getPermId->fetch();
    if ($permRow && isset($permRow['id'])) {
      $insRolePerm->execute([$adminRoleId, (int)$permRow['id']]);
    }
  }
}

echo "Seed de permisos de máscara aplicado.\n";
?>