<?php
/**
 * Test para verificar la respuesta JSON de add_note.php con sesión activa
 */

// Limpiar cualquier salida previa
ob_start();

// Incluir los archivos necesarios
require_once __DIR__ . '/../../database/config.php';
require_once __DIR__ . '/../../database/connection.php';

// Crear sesión activa
session_start();
$_SESSION['user_id'] = 1; // Simular usuario logueado

echo "=== TEST DE RESPUESTA JSON CON SESIÓN ACTIVA ===\n\n";

// Simular datos POST
$_POST = [
    'lead_id' => 3,
    'type' => 'note',
    'subject' => 'Test de respuesta JSON',
    'description' => 'Este es un test para verificar la respuesta JSON',
    'activity_date' => date('Y-m-d H:i:s'),
    'created_by' => 1
];

// También simular datos JSON
$json_input = json_encode($_POST);

// Capturar la respuesta
ob_start();
require_once 'add_note.php';
$output = ob_get_clean();

echo "Respuesta capturada:\n";
echo "Longitud: " . strlen($output) . " caracteres\n";
echo "Contenido: '" . $output . "'\n\n";

// Analizar la respuesta
if (empty($output)) {
    echo "⚠️ No hay salida\n";
} else {
    // Verificar si es JSON válido
    $json = json_decode($output, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "✅ JSON válido encontrado:\n";
        echo json_encode($json, JSON_PRETTY_PRINT) . "\n";
        
        if (isset($json['success']) && $json['success']) {
            echo "\n🎉 Test exitoso: La respuesta JSON es correcta\n";
        } else {
            echo "\n⚠️ La respuesta indica error: " . ($json['message'] ?? 'Sin mensaje') . "\n";
        }
    } else {
        echo "❌ Error de JSON: " . json_last_error_msg() . "\n";
        echo "Primeros 100 caracteres: " . substr($output, 0, 100) . "\n";
        echo "Códigos de caracteres iniciales: ";
        for ($i = 0; $i < min(10, strlen($output)); $i++) {
            echo ord($output[$i]) . " ";
        }
        echo "\n";
    }
}

echo "\n=== FIN DEL TEST ===\n";