<?php
/**
 * Test simple para agregar notas
 * Simula una petición AJAX desde el frontend
 */

// Simular sesión de usuario
session_start();
$_SESSION['user_id'] = 1;

// Datos de prueba
$testData = [
    'lead_id' => 3,
    'type' => 'email',
    'subject' => 'Test Email Frontend Simple',
    'description' => 'Este es un test simple de email desde el frontend',
    'activity_date' => date('Y-m-d H:i:s'),
    'created_by' => 1
];

echo "<h2>Test Simple - Agregar Nota</h2>";
echo "<h3>Datos de prueba:</h3>";
echo "<pre>" . json_encode($testData, JSON_PRETTY_PRINT) . "</pre>";

// Preparar la petición cURL
$ch = curl_init('http://127.0.0.1:8000/modules/leads/add_note.php');

// Configurar cURL para enviar JSON
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($testData),
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json',
        'Accept: application/json'
    ],
    CURLOPT_COOKIE => session_name() . '=' . session_id() // Mantener la sesión
]);

echo "<h3>Enviando petición a add_note.php...</h3>";

// Ejecutar la petición
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

curl_close($ch);

echo "<h3>Código HTTP: $httpCode</h3>";

if ($error) {
    echo "<h3>Error cURL:</h3>";
    echo "<pre>$error</pre>";
}

if ($response) {
    echo "<h3>Respuesta del servidor:</h3>";
    echo "<pre>" . json_encode(json_decode($response, true), JSON_PRETTY_PRINT) . "</pre>";
    
    // Verificar si la respuesta es exitosa
    $responseData = json_decode($response, true);
    if (isset($responseData['success']) && $responseData['success']) {
        echo "<h3 style='color: green;'>✅ ÉXITO: La actividad se agregó correctamente</h3>";
        echo "<p>ID de la actividad: " . ($responseData['activity']['id'] ?? 'N/A') . "</p>";
    } else {
        echo "<h3 style='color: red;'>❌ ERROR: " . ($responseData['message'] ?? 'Error desconocido') . "</h3>";
    }
} else {
    echo "<h3 style='color: red;'>❌ No hubo respuesta del servidor</h3>";
}

echo "<hr>";
echo "<h3>Verificando actividades del lead...</h3>";

// Verificar las actividades actuales
echo "<iframe src='debug_activities.php' width='100%' height='400px' style='border: 1px solid #ccc;'></iframe>";
?>