<?php
/**
 * Módulo Leads - Perfil del Lead Ultra Luxury
 */

$started = false;
if (session_status() === PHP_SESSION_NONE) { session_start(); $started = true; }
if (!defined('BASE_PATH')) { define('BASE_PATH', dirname(dirname(__DIR__))); }
require_once BASE_PATH . '/database/config.php';
require_once BASE_PATH . '/database/connection.php';
if (!function_exists('isLoggedIn')) {
    function isLoggedIn(){ return isset($_SESSION['user_id']) && !empty($_SESSION['user_id']); }
}

$current_module = 'leads';

if (!isLoggedIn()) {
    header('Location: ../../index.php?module=auth&action=login');
    exit;
}

$db = getDB();
$lead_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
if ($lead_id <= 0) {
    header('Location: ../../index.php?module=leads&error=invalid_id');
    exit;
}

// Obtener datos del lead con información extendida; si falla, usar consulta simple
$pdo_local = $db->getConnection();
$lead = null;
try {
    $stmt = $pdo_local->prepare(
        "SELECT l.*, 
                l.job_title AS position,
                u.username AS assigned_user,
                CONCAT(u.first_name, ' ', u.last_name) AS assigned_name,
                d.name AS desk_name,
                d.color AS desk_color
         FROM leads l
         LEFT JOIN users u ON l.assigned_to = u.id
         LEFT JOIN desks d ON l.desk_id = d.id
         WHERE l.id = ?"
    );
    $stmt->execute([$lead_id]);
    $lead = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Throwable $e) {
    // Fallback mínimo por si el esquema difiere
    try {
        $stmt = $pdo_local->prepare("SELECT * FROM leads WHERE id = ? LIMIT 1");
        $stmt->execute([$lead_id]);
        $lead = $stmt->fetch(PDO::FETCH_ASSOC);
    } catch (Throwable $e2) {
        $lead = false;
    }
}

if (!$lead) {
    header('Location: ../../index.php?module=leads&error=not_found&id=' . $lead_id);
    exit;
}

// Paginación para actividades
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = 5;
$offset = ($page - 1) * $limit;

// Contar total de actividades para paginación
$total_activities = $db->selectOne(
    "SELECT COUNT(*) as total FROM lead_activities WHERE lead_id = ?",
    [$lead_id]
)['total'];

$total_pages = ceil($total_activities / $limit);

// Actividades del lead con paginación
$activities = $db->select(
    "SELECT la.*, u.username AS creator_username, 
            CONCAT(u.first_name, ' ', u.last_name) AS creator_name
     FROM lead_activities la
     LEFT JOIN users u ON la.created_by = u.id
     WHERE la.lead_id = ?
     ORDER BY la.created_at DESC
     LIMIT ? OFFSET ?",
    [$lead_id, $limit, $offset]
);

// Estadísticas del lead
$stats = $db->selectOne(
    "SELECT 
        COUNT(CASE WHEN la.type = 'call' THEN 1 END) as total_calls,
        COUNT(CASE WHEN la.type = 'email' THEN 1 END) as total_emails,
        COUNT(CASE WHEN la.type = 'meeting' THEN 1 END) as total_meetings,
        COUNT(CASE WHEN la.type = 'task' AND la.status = 'completed' THEN 1 END) as completed_tasks,
        COUNT(CASE WHEN la.type = 'task' AND la.status = 'pending' THEN 1 END) as pending_tasks,
        MAX(la.created_at) as last_activity
     FROM lead_activities la
     WHERE la.lead_id = ?",
    [$lead_id]
);

// Permisos del usuario
$current_user_id = $_SESSION['user_id'] ?? 0;
$pdo_local = $db->getConnection();

// Funciones de permisos (simplificadas para el ejemplo)
function userHasPermissionByName($pdo, $permission, $user_id) {
    // Implementación simplificada - en producción usar la función real
    return true; // Por ahora permitir todo para el diseño
}

$canViewEmailFull = userHasPermissionByName($pdo_local, 'leads.view_email_full', $current_user_id);
$canViewPhoneFull = userHasPermissionByName($pdo_local, 'leads.view_phone_full', $current_user_id);
$canClickToCall = userHasPermissionByName($pdo_local, 'voiso.click_to_call', $current_user_id);

// Preparar variables de layout para usar el diseño corporativo con menú lateral
$page_title = 'Perfil del Lead - ' . htmlspecialchars(trim(($lead['first_name'] ?? '') . ' ' . ($lead['last_name'] ?? '')));
$module = 'leads';
$action = 'view';
$content_file = __DIR__ . '/view_content.php';

// Renderizar mediante el layout compartido que incluye el sidebar y estilos globales
include BASE_PATH . '/modules/shared/layout.php';