<?php
/**
 * Header compartido para todas las páginas
 */

// Obtener configuración dinámica del sistema
$company_name = APP_NAME; // Valor por defecto
$company_logo = '';

try {
    if (isset($pdo)) {
        $stmt = $pdo->prepare("SELECT config_key, config_value FROM system_config WHERE config_key IN ('company_name', 'company_logo')");
        $stmt->execute();
        $config_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        foreach ($config_items as $item) {
            if ($item['config_key'] === 'company_name' && !empty($item['config_value'])) {
                $company_name = $item['config_value'];
            } elseif ($item['config_key'] === 'company_logo' && !empty($item['config_value'])) {
                $company_logo = $item['config_value'];
            }
        }
    }
} catch (Exception $e) {
    // En caso de error, usar valores por defecto
    $company_name = APP_NAME;
    $company_logo = '';
}
?>

<header class="header">
    <div class="header-content">
        <div class="logo">
            <a href="?module=dashboard" style="color: white; text-decoration: none; display: flex; align-items: center; gap: 0.5rem;">
                <?php if (!empty($company_logo)): ?>
                    <img src="<?php echo htmlspecialchars($company_logo); ?>" alt="Logo" style="height: 32px; max-width: 120px; object-fit: contain;">
                <?php endif; ?>
                <span><?php echo htmlspecialchars($company_name); ?></span>
            </a>
        </div>
        
        <nav class="nav">
            <ul>
                <li><a href="?module=dashboard" class="<?php echo ($module === 'dashboard') ? 'active' : ''; ?>">Dashboard</a></li>
                <li><a href="?module=leads" class="<?php echo ($module === 'leads') ? 'active' : ''; ?>">Leads</a></li>
                <li><a href="?module=desks" class="<?php echo ($module === 'desks') ? 'active' : ''; ?>">Escritorios</a></li>
                <li><a href="?module=users" class="<?php echo ($module === 'users') ? 'active' : ''; ?>">Usuarios</a></li>
                <?php
                // Mostrar enlace de configuración solo para administradores
                if (isset($_SESSION['user_id']) && isset($pdo)) {
                    try {
                        $stmt = $pdo->prepare("
                            SELECT COUNT(*) 
                            FROM user_roles ur 
                            JOIN role_permissions rp ON ur.role_id = rp.role_id 
                            JOIN permissions p ON rp.permission_id = p.id 
                            WHERE ur.user_id = ? AND p.name = 'config.manage'
                        ");
                        $stmt->execute([$_SESSION['user_id']]);
                        $hasConfigPermission = $stmt->fetchColumn() > 0;
                        
                        if ($hasConfigPermission) {
                            echo '<li><a href="?module=config" class="' . (($module === 'config') ? 'active' : '') . '">Configuración</a></li>';
                        }
                    } catch (Exception $e) {
                        // En caso de error, no mostrar el enlace
                    }
                }
                ?>
            </ul>
        </nav>
        
        <div class="user-info">
            <span>Hola, <?php echo htmlspecialchars($_SESSION['user_name'] ?? 'Usuario'); ?></span>
            <a href="?module=auth&action=logout" class="btn btn-small">Salir</a>
        </div>
    </div>
</header>