<?php
/**
 * Sidebar compartido para todas las páginas del CRM
 */
// Asegurar que $current_module esté definido para evitar warnings
if (!isset($current_module)) {
    $current_module = $_GET['module'] ?? 'dashboard';
}
// Acción actual para resaltar submódulos como tickets
$current_action = $_GET['action'] ?? 'index';

// Helpers de permisos para visibilidad de menú
if (!function_exists('getDB')) {
    require_once BASE_PATH . '/database/connection.php';
}
$pdo = getDB()->getConnection();
$current_user_id = $_SESSION['user_id'] ?? null;

if (!function_exists('userHasPermissionByName')) {
    function userHasPermissionByName($pdo, $permName, $userId) {
        if (empty($userId)) return false;
        $stmt = $pdo->prepare("SELECT 1 FROM role_permissions rp INNER JOIN permissions p ON rp.permission_id = p.id INNER JOIN user_roles ur ON rp.role_id = ur.role_id WHERE ur.user_id = ? AND p.name = ? LIMIT 1");
        $stmt->execute([$userId, $permName]);
        return (bool)$stmt->fetchColumn();
    }
}
?>

<aside class="sidebar">
    <div class="sidebar-header">
        <div class="logo">
            <div class="logo-icon">
                <?php if (!empty($company_logo) && file_exists('../../public/uploads/' . $company_logo)): ?>
                    <img src="../../public/uploads/<?php echo htmlspecialchars($company_logo); ?>" alt="Logo" style="width: 32px; height: 32px; border-radius: 8px; object-fit: cover;">
                <?php else: ?>
                    <svg width="32" height="32" viewBox="0 0 32 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <rect width="32" height="32" rx="8" fill="#1e40af"/>
                        <path d="M8 12h16v2H8v-2zm0 4h16v2H8v-2zm0 4h12v2H8v-2z" fill="white"/>
                    </svg>
                <?php endif; ?>
            </div>
            <div class="logo-text">
                <?php
                // Obtener nombre de empresa y logo dinámicamente
                $company_name = 'ProfixCRM'; // Valor por defecto
                $company_logo = ''; // Sin logo por defecto
                
                try {
                    if (isset($pdo)) {
                        $stmt = $pdo->prepare("SELECT config_key, config_value FROM system_config WHERE config_key IN ('company_name', 'company_logo')");
                        $stmt->execute();
                        $config_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        
                        foreach ($config_items as $item) {
                            if ($item['config_key'] === 'company_name' && isset($item['config_value'])) {
                                $company_name = $item['config_value'];
                            } elseif ($item['config_key'] === 'company_logo' && !empty($item['config_value'])) {
                                $company_logo = $item['config_value'];
                            }
                        }
                    }
                } catch (Exception $e) {
                    // En caso de error, usar valores por defecto
                    $company_name = 'ProfixCRM';
                    $company_logo = '';
                }
                ?>
                <span class="logo-title"><?php echo htmlspecialchars($company_name); ?></span>
            </div>
        </div>
    </div>

    <nav class="sidebar-nav">
        <ul class="nav-list">
            <?php if (userHasPermissionByName($pdo, 'menu.dashboard.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=dashboard" class="nav-link <?php echo ($current_module == 'dashboard') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="3" y="3" width="7" height="7"/>
                            <rect x="14" y="3" width="7" height="7"/>
                            <rect x="14" y="14" width="7" height="7"/>
                            <rect x="3" y="14" width="7" height="7"/>
                        </svg>
                    </div>
                    <span class="nav-text">Dashboard</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.leads.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=leads" class="nav-link <?php echo ($current_module == 'leads') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="m22 2-5 10-5-5-5 10"/>
                        </svg>
                    </div>
                    <span class="nav-text">Leads</span>
                    <?php if (isset($leads_count) && $leads_count > 0): ?>
                        <span class="nav-badge"><?php echo $leads_count; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <?php endif; ?>

            <?php if (userHasPermissionByName($pdo, 'menu.clients.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=clients" class="nav-link <?php echo ($current_module == 'clients') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M16 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="9" cy="7" r="4"/>
                            <path d="M20 8v6m3-3h-6"/>
                        </svg>
                    </div>
                    <span class="nav-text">Clientes</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.desks.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=desks" class="nav-link <?php echo ($current_module == 'desks') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"/>
                            <line x1="8" y1="21" x2="16" y2="21"/>
                            <line x1="12" y1="17" x2="12" y2="21"/>
                        </svg>
                    </div>
                    <span class="nav-text">Desks</span>
                </a>
            </li>
            <?php endif; ?>

            <?php if (userHasPermissionByName($pdo, 'menu.tickets.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=desks&action=tickets" class="nav-link <?php echo ($current_module == 'desks' && $current_action == 'tickets') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M4 7h16v10H4z"/>
                            <path d="M8 11h8M8 15h6"/>
                        </svg>
                    </div>
                    <span class="nav-text">Soporte</span>
                    <?php
                        // Mostrar badge separado: open | pending
                        $openCount = 0; $pendingCount = 0;
                        if (userHasPermissionByName($pdo, 'tickets.view', (int)$current_user_id)) {
                            $stmtTC = $pdo->query("SELECT status, COUNT(*) as cnt FROM support_tickets WHERE status IN ('open','pending') GROUP BY status");
                            while ($r = $stmtTC->fetch()) {
                                if ($r['status'] === 'open') { $openCount = (int)$r['cnt']; }
                                elseif ($r['status'] === 'pending') { $pendingCount = (int)$r['cnt']; }
                            }
                        }
                        if ($openCount > 0 || $pendingCount > 0): ?>
                        <span class="nav-badge"><?php echo $openCount . ' | ' . $pendingCount; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.users.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=users" class="nav-link <?php echo ($current_module == 'users') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="12" cy="7" r="4"/>
                        </svg>
                    </div>
                    <span class="nav-text">Users</span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (userHasPermissionByName($pdo, 'menu.roles.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=roles" class="nav-link <?php echo ($current_module == 'roles') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <span class="nav-text">Roles y Permisos</span>
                </a>
            </li>
            <?php endif; ?>

            <div class="nav-divider"></div>

            <?php if (userHasPermissionByName($pdo, 'menu.integrations.view', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=integrations" class="nav-link <?php echo ($current_module == 'integrations') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M4 12h16M12 4v16"/>
                        </svg>
                    </div>
                    <span class="nav-text">Integraciones</span>
                </a>
            </li>
            <?php endif; ?>

            <?php if (userHasPermissionByName($pdo, 'config.manage', $current_user_id)) : ?>
            <li class="nav-item">
                <a href="?module=config" class="nav-link <?php echo ($current_module == 'config') ? 'active' : ''; ?>">
                    <div class="nav-icon">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <circle cx="12" cy="12" r="3"/>
                            <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1-1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
                        </svg>
                    </div>
                    <span class="nav-text">Configuración</span>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    </nav>

    <div class="sidebar-footer">
        <div class="user-profile">
            <div class="user-avatar">
                <div class="avatar-circle">
                    <?php echo strtoupper(substr($_SESSION['user_name'] ?? 'U', 0, 1)); ?>
                </div>
            </div>
            <div class="user-info">
                <div class="user-name"><?php echo htmlspecialchars($_SESSION['user_name'] ?? 'Usuario'); ?></div>
                <div class="user-role">Administrador</div>
            </div>
        </div>
        
        <div class="logout-section">
            <a href="?module=auth&action=logout" class="logout-btn" title="Cerrar Sesión">
                <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M7 17H2a2 2 0 01-2-2V3a2 2 0 012-2h5m6 4l4 4-4 4m4-4H9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </a>
        </div>
    </div>
</aside>