<?php
/**
 * Script de prueba para simular el envío de una actividad
 */

require_once 'database/config.php';
require_once 'database/connection.php';
session_start();

// Simular sesión de usuario
$_SESSION['user_id'] = 1;

echo "<h2>Test de Agregar Nota</h2>\n";

try {
    // Simular datos de POST
    $test_data = [
        'lead_id' => 3,
        'type' => 'note',
        'subject' => 'Prueba de actividad',
        'description' => 'Esta es una prueba para verificar si las actividades se guardan correctamente',
        'activity_date' => date('Y-m-d H:i:s'),
        'created_by' => 1
    ];
    
    echo "<h3>Datos de prueba:</h3>\n";
    echo "<pre>" . print_r($test_data, true) . "</pre>\n";
    
    // Simular el proceso de add_note.php
    $db = getDB();
    
    // Verificar conexión
    if (!$db) {
        throw new Exception('No se pudo conectar a la base de datos');
    }
    echo "<p style='color: green;'>✓ Conexión a base de datos exitosa</p>\n";
    
    // Verificar que el lead existe
    $lead = $db->selectOne('SELECT id FROM leads WHERE id = ?', [$test_data['lead_id']]);
    if (!$lead) {
        throw new Exception('Lead no encontrado');
    }
    echo "<p style='color: green;'>✓ Lead ID {$test_data['lead_id']} existe</p>\n";
    
    // Intentar insertar la actividad
    echo "<h3>Insertando actividad...</h3>\n";
    
    $result = $db->execute(
        "INSERT INTO lead_activities (lead_id, type, subject, description, status, created_by, created_at)
         VALUES (?, ?, ?, ?, 'completed', ?, ?)",
        [
            $test_data['lead_id'], 
            $test_data['type'], 
            $test_data['subject'], 
            $test_data['description'], 
            $test_data['created_by'], 
            $test_data['activity_date']
        ]
    );
    
    if ($result) {
        $activity_id = $db->lastInsertId();
        echo "<p style='color: green;'>✓ Actividad insertada exitosamente con ID: {$activity_id}</p>\n";
        
        // Actualizar lead
        $db->execute(
            "UPDATE leads SET updated_at = ? WHERE id = ?",
            [$test_data['activity_date'], $test_data['lead_id']]
        );
        echo "<p style='color: green;'>✓ Lead actualizado</p>\n";
        
        // Verificar que se guardó
        $saved_activity = $db->selectOne(
            "SELECT * FROM lead_activities WHERE id = ?", 
            [$activity_id]
        );
        
        if ($saved_activity) {
            echo "<h3>Actividad guardada:</h3>\n";
            echo "<pre>" . print_r($saved_activity, true) . "</pre>\n";
        }
        
    } else {
        throw new Exception('Error al insertar la actividad');
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>\n";
    echo "<pre>" . $e->getTraceAsString() . "</pre>\n";
}

echo "<hr>";
echo "<p><a href='debug_activities.php'>Ver debug de actividades</a></p>";
echo "<p><a href='index.php?module=leads&action=view&id=3'>Ver Lead ID 3</a></p>";
?>