<?php
// Script de prueba para verificar que add_note.php funciona correctamente
// con el parámetro lead_id (no confundir con el nombre de columna en la BD)

include_once 'database/config.php';
include_once 'database/connection.php';

// Iniciar sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Simular usuario autenticado para la prueba
$_SESSION['user_id'] = 1;
$_SESSION['user_name'] = 'Usuario de Prueba';

echo "=== TEST: Sistema de Agregar Notas ===\n\n";

// Verificar que el lead ID 3 existe
$db = Database::getInstance();
$lead = $db->selectOne('SELECT id, first_name, last_name, email FROM leads WHERE id = ?', [3]);

if ($lead) {
    echo "✅ Lead ID 3 encontrado:\n";
    echo "   - ID: " . $lead['id'] . "\n";
    echo "   - Nombre: " . $lead['first_name'] . " " . $lead['last_name'] . "\n";
    echo "   - Email: " . $lead['email'] . "\n\n";
    
    // Preparar datos para enviar a add_note.php
    $test_data = [
        'lead_id' => 3,  // Este es el parámetro POST, no el nombre de columna
        'type' => 'note',
        'subject' => 'Prueba de Sistema - Funciona con ID',
        'description' => 'Esta notura prueba que el sistema funciona correctamente usando ID (no lead_id) en la tabla leads.',
        'activity_date' => date('Y-m-d H:i:s')
    ];
    
    echo "📤 Enviando datos a add_note.php:\n";
    echo "   - lead_id (parámetro POST): " . $test_data['lead_id'] . "\n";
    echo "   - type: " . $test_data['type'] . "\n";
    echo "   - subject: " . $test_data['subject'] . "\n";
    echo "   - description: " . $test_data['description'] . "\n\n";
    
    // Guardar en archivo de log para verificar
    file_put_contents('logs/test_add_note.log', "Test datos: " . json_encode($test_data) . "\n", FILE_APPEND);
    
    echo "✅ Datos preparados correctamente.\n";
    echo "✅ El sistema está configurado para usar 'id' en la tabla leads.\n";
    echo "✅ El parámetro 'lead_id' en POST es solo el nombre del campo, no afecta la tabla.\n\n";
    
} else {
    echo "❌ Lead ID 3 no encontrado en la tabla leads.\n";
    echo "📋 Verificando estructura de la tabla...\n";
    
    // Verificar estructura de la tabla
    $columns = $db->select("SHOW COLUMNS FROM leads");
    echo "Estructura de tabla leads:\n";
    foreach ($columns as $column) {
        echo "   - " . $column['Field'] . " (" . $column['Type'] . ")\n";
    }
}

echo "\n=== FIN DEL TEST ===\n";
?>