<?php
// Script de prueba para el endpoint AJAX de paginación
session_start();
$_SESSION['user_id'] = 1; // Simular usuario autenticado

// Simular los parámetros GET
$_GET['lead_id'] = 1;
$_GET['page'] = 1;

// Incluir y ejecutar el endpoint
ob_start(); // Capturar la salida JSON
require_once 'modules/leads/load_activities_ajax.php';
$json_output = ob_get_clean();

// Ahora mostrar los resultados
echo "<h3>Probando endpoint AJAX de paginación...</h3>";
echo "<p>Lead ID: {$_GET['lead_id']}</p>";
echo "<p>Página: {$_GET['page']}</p>";
echo "<hr>";

echo "<h4>Respuesta JSON:</h4>";
echo "<pre>" . htmlspecialchars($json_output) . "</pre>";

// Decodificar y mostrar datos
$data = json_decode($json_output, true);
if ($data) {
    echo "<h4>Datos decodificados:</h4>";
    echo "<p>Success: " . ($data['success'] ? 'true' : 'false') . "</p>";
    echo "<p>Total activities: " . ($data['total_activities'] ?? 'N/A') . "</p>";
    echo "<p>HTML length: " . strlen($data['html'] ?? '') . " caracteres</p>";
    echo "<p>Pagination HTML length: " . strlen($data['pagination_html'] ?? '') . " caracteres</p>";
    
    if (isset($data['message'])) {
        echo "<p>Message: " . htmlspecialchars($data['message']) . "</p>";
    }
} else {
    echo "<p style='color: red;'>Error al decodificar JSON</p>";
    echo "<p>JSON Error: " . json_last_error_msg() . "</p>";
}

session_destroy();