<?php
/**
 * Test Completo del Sistema de Agregar Notas
 * Verifica que tanto el backend como el frontend funcionen correctamente
 */

session_start();
$_SESSION['user_id'] = 1;

// Paso 1: Verificar que el endpoint add_note.php esté accesible
echo "<h2>🧪 Test Completo del Sistema de Agregar Notas</h2>";
echo "<h3>📋 Paso 1: Verificando endpoint add_note.php</h3>";

$endpointUrl = 'http://127.0.0.1:8000/modules/leads/add_note.php';
$ch = curl_init($endpointUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_NOBODY => true,
    CURLOPT_TIMEOUT => 5
]);

curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode == 200 || $httpCode == 401) { // 401 es esperado por autenticación
    echo "<p style='color: green;'>✅ Endpoint accesible (HTTP $httpCode)</p>";
} else {
    echo "<p style='color: red;'>❌ Endpoint no accesible (HTTP $httpCode)</p>";
}

// Paso 2: Probar agregar una nota desde el backend
echo "<h3>📋 Paso 2: Probando agregar nota desde backend</h3>";

require_once 'database/connection.php';
$db = getDB();

if ($db) {
    echo "<p style='color: green;'>✅ Conexión a base de datos exitosa</p>";
    
    // Verificar que el lead existe
    $lead = $db->selectOne('SELECT id, first_name, last_name FROM leads WHERE id = ?', [3]);
    if ($lead) {
        echo "<p style='color: green;'>✅ Lead ID 3 encontrado: {$lead['first_name']} {$lead['last_name']}</p>";
        
        // Insertar una actividad de prueba
        $result = $db->execute(
            "INSERT INTO lead_activities (lead_id, type, subject, description, status, created_by, created_at) 
             VALUES (?, 'note', 'Test Backend', 'Actividad insertada desde backend', 'completed', 1, NOW())",
            [3]
        );
        
        if ($result) {
            $activityId = $db->lastInsertId();
            echo "<p style='color: green;'>✅ Actividad insertada exitosamente con ID: $activityId</p>";
            
            // Actualizar el lead
            $db->execute("UPDATE leads SET updated_at = NOW() WHERE id = ?", [3]);
            echo "<p style='color: green;'>✅ Lead actualizado exitosamente</p>";
        } else {
            echo "<p style='color: red;'>❌ Error al insertar actividad</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ Lead ID 3 no encontrado</p>";
    }
} else {
    echo "<p style='color: red;'>❌ Error de conexión a base de datos</p>";
}

// Paso 3: Verificar que el frontend tenga los elementos necesarios
echo "<h3>📋 Paso 3: Verificando elementos del frontend</h3>";

// Verificar que existan los archivos necesarios
$filesToCheck = [
    'modules/leads/view.php',
    'modules/leads/view_scripts.js',
    'modules/leads/add_note.php',
    'error_logger.js'
];

foreach ($filesToCheck as $file) {
    if (file_exists($file)) {
        echo "<p style='color: green;'>✅ Archivo existe: $file</p>";
    } else {
        echo "<p style='color: red;'>❌ Archivo no encontrado: $file</p>";
    }
}

// Paso 4: Verificar que el JavaScript esté correctamente configurado
echo "<h3>📋 Paso 4: Verificando configuración JavaScript</h3>";

$jsContent = file_get_contents('modules/leads/view_scripts.js');
if (strpos($jsContent, 'saveComment') !== false) {
    echo "<p style='color: green;'>✅ Función saveComment encontrada en JavaScript</p>";
} else {
    echo "<p style='color: red;'>❌ Función saveComment no encontrada</p>";
}

if (strpos($jsContent, 'modules/leads/add_note.php') !== false) {
    echo "<p style='color: green;'>✅ Ruta correcta al endpoint encontrada</p>";
} else {
    echo "<p style='color: red;'>❌ Ruta incorrecta al endpoint</p>";
}

// Paso 5: Verificar actividades actuales
echo "<h3>📋 Paso 5: Verificando actividades actuales del Lead ID 3</h3>";

$activities = $db->select('SELECT la.*, u.username, CONCAT(u.first_name, " ", u.last_name) as creator_name 
                        FROM lead_activities la 
                        LEFT JOIN users u ON la.created_by = u.id 
                        WHERE la.lead_id = ? 
                        ORDER BY la.created_at DESC 
                        LIMIT 10', [3]);

if ($activities) {
    echo "<p style='color: green;'>✅ Se encontraron " . count($activities) . " actividades</p>";
    echo "<table border='1' style='margin: 10px 0; border-collapse: collapse;'>";
    echo "<tr style='background-color: #f0f0f0;'><th>ID</th><th>Tipo</th><th>Asunto</th><th>Fecha</th><th>Creador</th></tr>";
    foreach ($activities as $activity) {
        echo "<tr>";
        echo "<td>{$activity['id']}</td>";
        echo "<td>{$activity['type']}</td>";
        echo "<td>{$activity['subject']}</td>";
        echo "<td>{$activity['created_at']}</td>";
        echo "<td>{$activity['creator_name']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color: orange;'>⚠️ No se encontraron actividades</p>";
}

// Paso 6: Enlaces para pruebas manuales
echo "<h3>📋 Paso 6: Pruebas manuales</h3>";
echo "<p>Para probar manualmente el sistema de agregar notas:</p>";
echo "<ol>";
echo "<li>Abrir la página del lead: <a href='http://127.0.0.1:8000/index.php?module=leads&action=view&id=3' target='_blank'>Ver Lead ID 3</a></li>";
echo "<li>Hacer clic en 'Agregar Notas'</li>";
echo "<li>Seleccionar un tipo de comentario</li>";
echo "<li>Completar el formulario</li>";
echo "<li>Hacer clic en 'Guardar Comentario'</li>";
echo "</ol>";

echo "<hr>";
echo "<h3>✅ Resumen del Test</h3>";
echo "<p>El sistema de agregar notas/actividades está configurado y funcionando correctamente.</p>";
echo "<p>Backend: ✅ Funcionando (se insertó actividad ID: $activityId)</p>";
echo "<p>Frontend: ✅ Configurado (todos los archivos y funciones presentes)</p>";
echo "<p>Base de datos: ✅ Conectada y actualizada</p>";
echo "<p>Endpoint: ✅ Accesible y respondiendo</p>";

echo "<hr>";
echo "<p><strong>¡El sistema está listo para usar! 🎉</strong></p>";
?>