<?php
session_start();
$_SESSION['user_id'] = 1; // Simular usuario autenticado

echo "<!DOCTYPE html>
<html lang='es'>
<head>
    <meta charset='UTF-8'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Test Final de Paginación</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 1200px; margin: 0 auto; padding: 20px; }
        .test-section { background: #f8f9fa; padding: 20px; margin: 20px 0; border-radius: 8px; }
        .success { color: #28a745; font-weight: bold; }
        .error { color: #dc3545; font-weight: bold; }
        .info { color: #17a2b8; }
        .btn { background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; margin: 5px; }
        .btn:hover { background: #0056b3; }
        #activityTimeline { border: 1px solid #ddd; padding: 15px; margin: 10px 0; min-height: 200px; background: white; }
        .pagination-controls { margin: 20px 0; text-align: center; }
        .pagination-container { display: flex; justify-content: center; gap: 8px; flex-wrap: wrap; }
        .pagination-btn { padding: 8px 12px; border: 1px solid #ddd; background: white; color: #333; border-radius: 6px; cursor: pointer; }
        .pagination-btn:hover { background: #f8f9fa; border-color: #007bff; color: #007bff; }
        .pagination-btn.pagination-active { background: #007bff; color: white; border-color: #007bff; }
    </style>
</head>
<body>
    <h1>🧪 Test Final de Paginación - ProFix CRM</h1>";

// Test 1: Verificar endpoint AJAX
echo "<div class='test-section'>
    <h3>1. Test de Endpoint AJAX</h3>";

$_GET['lead_id'] = 1;
$_GET['page'] = 1;

ob_start();
require_once 'modules/leads/load_activities_ajax.php';
$json_output = ob_get_clean();

$data = json_decode($json_output, true);
if ($data && $data['success']) {
    echo "<div class='success'>✓ Endpoint AJAX funciona correctamente</div>";
    echo "<div class='info'>Total actividades: " . $data['total_activities'] . "</div>";
    echo "<div class='info'>Total páginas: " . $data['total_pages'] . "</div>";
} else {
    echo "<div class='error'>✗ Error en endpoint AJAX</div>";
    echo "<pre>" . htmlspecialchars($json_output) . "</pre>";
}
echo "</div>";

// Test 2: Verificar que view_scripts.js existe
echo "<div class='test-section'>
    <h3>2. Test de Archivos JavaScript</h3>";

if (file_exists('modules/leads/view_scripts.js')) {
    $js_content = file_get_contents('modules/leads/view_scripts.js');
    if (strpos($js_content, 'loadActivitiesPage') !== false) {
        echo "<div class='success'>✓ Función loadActivitiesPage encontrada en view_scripts.js</div>";
    } else {
        echo "<div class='error'>✗ Función loadActivitiesPage no encontrada</div>";
    }
} else {
    echo "<div class='error'>✗ Archivo view_scripts.js no encontrado</div>";
}
echo "</div>";

// Test 3: Simulación completa
echo "<div class='test-section'>
    <h3>3. Simulación de Paginación Completa</h3>
    <p>Esta sección simula el comportamiento completo de la paginación:</p>
    
    <div id='activityTimeline'>
        <div class='info'>Las actividades aparecerán aquí...</div>
    </div>
    
    <div class='pagination-controls' id='paginationControls'>
        <div class='info'>Los controles de paginación aparecerán aquí...</div>
    </div>
    
    <button class='btn' onclick='testPagination()'>Probar Paginación</button>
    <button class='btn' onclick='loadPage(1)'>Página 1</button>
    <button class='btn' onclick='loadPage(2)'>Página 2</button>
</div>";

echo "<script>
// Configurar leadData
window.leadData = { id: 1 };

function loadPage(page) {
    const timeline = document.getElementById('activityTimeline');
    const pagination = document.getElementById('paginationControls');
    
    timeline.innerHTML = '<div class=\"info\">Cargando página ' + page + '...</div>';
    
    fetch('modules/leads/load_activities_ajax.php?lead_id=1&page=' + page)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                timeline.innerHTML = data.html;
                pagination.innerHTML = data.pagination_html;
                console.log('Página ' + page + ' cargada exitosamente');
            } else {
                timeline.innerHTML = '<div class=\"error\">Error: ' + (data.message || 'Error desconocido') + '</div>';
            }
        })
        .catch(error => {
            timeline.innerHTML = '<div class=\"error\">Error de red: ' + error.message + '</div>';
            console.error('Error:', error);
        });
}

function loadActivitiesPage(page) {
    loadPage(page);
}

function testPagination() {
    console.log('Iniciando test de paginación...');
    loadPage(1);
    
    setTimeout(() => {
        console.log('Cargando página 2...');
        loadPage(2);
    }, 2000);
}

// Auto-cargar página 1 al inicio
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        loadPage(1);
    }, 500);
});
</script>";

echo "<div class='test-section'>
    <h3>4. Enlaces de Prueba</h3>
    <p><a href='modules/leads/view.php?id=1' target='_blank' class='btn'>Ver Perfil del Lead (Página Real)</a></p>
    <p><a href='test_pagination_browser.html' target='_blank' class='btn'>Test de Paginación Independiente</a></p>
</div>";

echo "</body></html>";

session_destroy();
?>