<?php
// Test de verificación final de paginación después de correcciones
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificación Final de Paginación</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .test-section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
        .success { background-color: #d4edda; border-color: #c3e6cb; }
        .error { background-color: #f8d7da; border-color: #f5c6cb; }
        .info { background-color: #d1ecf1; border-color: #bee5eb; }
        .test-button { padding: 10px 20px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer; }
        .test-button:hover { background: #0056b3; }
        #results { margin-top: 20px; }
    </style>
</head>
<body>
    <h1>🔍 Verificación Final de Paginación</h1>
    
    <div class="test-section info">
        <h3>Estado del Sistema</h3>
        <p><strong>Fecha:</strong> <?= date('Y-m-d H:i:s') ?></p>
        <p><strong>Servidor:</strong> <?= $_SERVER['HTTP_HOST'] ?></p>
        <p><strong>Correcciones aplicadas:</strong> ✅ Error de ErrorLogger duplicado corregido</p>
    </div>

    <div class="test-section">
        <h3>1. Verificar Endpoint AJAX</h3>
        <button class="test-button" onclick="testAjaxEndpoint()">Probar Endpoint</button>
        <div id="ajax-result"></div>
    </div>

    <div class="test-section">
        <h3>2. Verificar JavaScript</h3>
        <button class="test-button" onclick="testJavaScript()">Verificar JS</button>
        <div id="js-result"></div>
    </div>

    <div class="test-section">
        <h3>3. Simular Paginación</h3>
        <button class="test-button" onclick="simulatePagination()">Simular Clicks</button>
        <div id="pagination-result"></div>
    </div>

    <div class="test-section">
        <h3>4. Verificar Errores de Consola</h3>
        <button class="test-button" onclick="checkConsoleErrors()">Verificar Errores</button>
        <div id="console-result"></div>
    </div>

    <div id="results"></div>

    <script>
        let testResults = [];

        function addResult(test, status, message) {
            testResults.push({test, status, message, time: new Date().toLocaleTimeString()});
            updateResults();
        }

        function updateResults() {
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = '<h3>Resultados de Pruebas:</h3>';
            testResults.forEach(result => {
                const className = result.status === 'success' ? 'success' : 'error';
                resultsDiv.innerHTML += `
                    <div class="test-section ${className}">
                        <strong>${result.test}</strong> [${result.time}]<br>
                        ${result.message}
                    </div>
                `;
            });
        }

        async function testAjaxEndpoint() {
            const resultDiv = document.getElementById('ajax-result');
            resultDiv.innerHTML = 'Probando endpoint...';
            
            try {
                const response = await fetch('modules/leads/load_activities_ajax.php?lead_id=1&page=1');
                const data = await response.json();
                
                if (data.success && data.activities_html && data.pagination_html) {
                    resultDiv.innerHTML = '✅ Endpoint funciona correctamente';
                    addResult('Endpoint AJAX', 'success', 'El endpoint devuelve JSON válido con datos de actividades y paginación');
                } else {
                    resultDiv.innerHTML = '❌ Endpoint no devuelve datos válidos';
                    addResult('Endpoint AJAX', 'error', 'El endpoint no devuelve la estructura esperada');
                }
            } catch (error) {
                resultDiv.innerHTML = '❌ Error al conectar con endpoint: ' + error.message;
                addResult('Endpoint AJAX', 'error', 'Error de conexión: ' + error.message);
            }
        }

        function testJavaScript() {
            const resultDiv = document.getElementById('js-result');
            
            // Verificar si loadActivitiesPage existe
            if (typeof loadActivitiesPage === 'function') {
                resultDiv.innerHTML = '✅ Función loadActivitiesPage encontrada';
                addResult('JavaScript', 'success', 'La función loadActivitiesPage está disponible');
            } else {
                resultDiv.innerHTML = '❌ Función loadActivitiesPage no encontrada';
                addResult('JavaScript', 'error', 'La función loadActivitiesPage no está disponible');
            }
        }

        function simulatePagination() {
            const resultDiv = document.getElementById('pagination-result');
            resultDiv.innerHTML = 'Simulando clicks de paginación...';
            
            // Simular que tenemos la función loadActivitiesPage
            if (typeof loadActivitiesPage !== 'function') {
                window.loadActivitiesPage = function(page) {
                    console.log('Simulando carga de página:', page);
                    return fetch(`modules/leads/load_activities_ajax.php?lead_id=1&page=${page}`)
                        .then(response => response.json())
                        .then(data => {
                            console.log('Datos recibidos:', data);
                            return data;
                        });
                };
            }
            
            // Probar diferentes páginas
            Promise.all([
                loadActivitiesPage(1),
                loadActivitiesPage(2)
            ]).then(results => {
                const allSuccess = results.every(result => result && result.success);
                if (allSuccess) {
                    resultDiv.innerHTML = '✅ Simulación de paginación exitosa';
                    addResult('Simulación Paginación', 'success', 'Las páginas 1 y 2 se cargan correctamente');
                } else {
                    resultDiv.innerHTML = '❌ Error en simulación de paginación';
                    addResult('Simulación Paginación', 'error', 'Algunas páginas no se cargan correctamente');
                }
            }).catch(error => {
                resultDiv.innerHTML = '❌ Error en simulación: ' + error.message;
                addResult('Simulación Paginación', 'error', 'Error: ' + error.message);
            });
        }

        function checkConsoleErrors() {
            const resultDiv = document.getElementById('console-result');
            
            // Verificar si hay errores en la consola
            const originalError = console.error;
            let errorCount = 0;
            
            console.error = function(...args) {
                errorCount++;
                originalError.apply(console, args);
            };
            
            // Esperar un momento para capturar errores
            setTimeout(() => {
                console.error = originalError;
                
                if (errorCount === 0) {
                    resultDiv.innerHTML = '✅ No se detectaron errores en consola';
                    addResult('Errores de Consola', 'success', 'No hay errores de JavaScript en la consola');
                } else {
                    resultDiv.innerHTML = `❌ Se detectaron ${errorCount} errores en consola`;
                    addResult('Errores de Consola', 'error', `Se encontraron ${errorCount} errores en la consola`);
                }
            }, 2000);
            
            resultDiv.innerHTML = 'Monitoreando errores de consola...';
        }

        // Ejecutar pruebas automáticamente al cargar
        window.onload = function() {
            setTimeout(() => {
                testAjaxEndpoint();
                setTimeout(() => testJavaScript(), 1000);
                setTimeout(() => simulatePagination(), 2000);
                setTimeout(() => checkConsoleErrors(), 3000);
            }, 500);
        };
    </script>
</body>
</html>