<?php
/**
 * Prueba específica para diagnosticar el error "ID del rol es requerido"
 */

// Iniciar sesión si no está iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Simular usuario logueado para las pruebas
$_SESSION['user_id'] = 1;
$_SESSION['username'] = 'test_user';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Debug Role ID Error</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .test-section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
        button { padding: 10px 15px; margin: 5px; }
        pre { background: #f5f5f5; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>🔍 Debug: Error "ID del rol es requerido"</h1>
    
    <div class="test-section">
        <h3>Pruebas del endpoint get_role_details</h3>
        <button onclick="testWithRoleId()">✅ Probar CON role_id=1</button>
        <button onclick="testWithoutRoleId()">❌ Probar SIN role_id</button>
        <button onclick="testWithEmptyRoleId()">❌ Probar con role_id vacío</button>
        <button onclick="testOriginalEditRole()">🔄 Simular editRole original</button>
    </div>

    <div id="results"></div>

    <script>
        function addResult(message, isSuccess = null) {
            const results = document.getElementById('results');
            const div = document.createElement('div');
            div.innerHTML = `<strong>${new Date().toLocaleTimeString()}</strong>: ${message}`;
            
            if (isSuccess === true) div.className = 'success';
            else if (isSuccess === false) div.className = 'error';
            else div.className = 'info';
            
            results.appendChild(div);
            results.scrollTop = results.scrollHeight;
        }

        async function testWithRoleId() {
            addResult('🔄 Probando GET con role_id=1...', null);
            try {
                const response = await fetch('modules/roles/actions.php?action=get_role_details&role_id=1', {
                    method: 'GET'
                });
                
                const text = await response.text();
                addResult(`Status: ${response.status}`, response.ok);
                addResult(`Response: ${text}`, response.ok);
                
                if (response.ok) {
                    try {
                        const data = JSON.parse(text);
                        addResult('✅ JSON válido recibido', true);
                    } catch (e) {
                        addResult('❌ Error parseando JSON: ' + e.message, false);
                    }
                }
            } catch (error) {
                addResult('❌ Error de red: ' + error.message, false);
            }
        }

        async function testWithoutRoleId() {
            addResult('🔄 Probando GET sin role_id...', null);
            try {
                const response = await fetch('modules/roles/actions.php?action=get_role_details', {
                    method: 'GET'
                });
                
                const text = await response.text();
                addResult(`Status: ${response.status}`, response.ok);
                addResult(`Response: ${text}`, response.ok);
                
                // Esperamos un error 400 con "ID del rol es requerido"
                if (response.status === 400 && text.includes('ID del rol es requerido')) {
                    addResult('✅ Error esperado recibido correctamente', true);
                }
            } catch (error) {
                addResult('❌ Error de red: ' + error.message, false);
            }
        }

        async function testWithEmptyRoleId() {
            addResult('🔄 Probando GET con role_id vacío...', null);
            try {
                const response = await fetch('modules/roles/actions.php?action=get_role_details&role_id=', {
                    method: 'GET'
                });
                
                const text = await response.text();
                addResult(`Status: ${response.status}`, response.ok);
                addResult(`Response: ${text}`, response.ok);
            } catch (error) {
                addResult('❌ Error de red: ' + error.message, false);
            }
        }

        async function testOriginalEditRole() {
            addResult('🔄 Simulando función editRole original con roleId=1...', null);
            const roleId = 1;
            
            try {
                // Exactamente como en la función original
                const resp = await fetch(`modules/roles/actions.php?action=get_role_details&role_id=${encodeURIComponent(roleId)}`);
                
                addResult(`Status: ${resp.status}`, resp.ok);
                addResult(`Status Text: ${resp.statusText}`, resp.ok);
                
                const data = await resp.json();
                addResult(`JSON Response: ${JSON.stringify(data, null, 2)}`, resp.ok);
                
                if (data.error || data.success === false) {
                    addResult(`⚠️ Error del servidor: ${data.error || data.message || 'No autorizado'}`, false);
                } else if (data.role) {
                    addResult(`✅ Éxito: Datos del rol obtenidos`, true);
                } else {
                    addResult(`⚠️ Respuesta sin datos de rol`, false);
                }
                
            } catch (e) {
                addResult(`❌ Error en editRole: ${e.message}`, false);
                addResult(`🔍 Tipo de error: ${e.constructor.name}`, false);
            }
        }

        // Mensaje inicial
        addResult('🚀 Sistema de debug iniciado. Haz clic en los botones para probar diferentes escenarios.', null);
    </script>
</body>
</html>