<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test - Roles AJAX</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .test-section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
        .success { background-color: #d4edda; border-color: #c3e6cb; color: #155724; }
        .error { background-color: #f8d7da; border-color: #f5c6cb; color: #721c24; }
        .info { background-color: #d1ecf1; border-color: #bee5eb; color: #0c5460; }
        button { padding: 10px 15px; margin: 5px; background: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer; }
        button:hover { background: #0056b3; }
        pre { background: #f8f9fa; padding: 10px; border-radius: 3px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>🧪 Test de Rutas AJAX - Módulo de Roles</h1>
    
    <div class="test-section info">
        <h3>📋 Información</h3>
        <p>Este test verifica que las rutas AJAX del módulo de roles funcionen correctamente en producción.</p>
        <p><strong>Problema original:</strong> Error "Unexpected token '<', "<!DOCTYPE "... is not valid JSON"</p>
        <p><strong>Causa:</strong> Rutas absolutas incorrectas que devolvían HTML en lugar de JSON</p>
    </div>

    <div class="test-section">
        <h3>🔧 Tests Disponibles</h3>
        <button onclick="testEndpoint('get_role_details', 'GET')">Test: Obtener Detalles de Rol</button>
        <button onclick="testEndpoint('get_users', 'GET')">Test: Obtener Usuarios de Rol</button>
        <button onclick="testCreateRole()">Test: Crear Rol (Simulado)</button>
        <button onclick="testUpdatePermissions()">Test: Actualizar Permisos (Simulado)</button>
    </div>

    <div id="results"></div>

    <script>
        async function testEndpoint(action, method = 'GET', data = null) {
            const resultsDiv = document.getElementById('results');
            const testId = Date.now();
            
            // Agregar sección de resultado
            const resultSection = document.createElement('div');
            resultSection.className = 'test-section';
            resultSection.id = `test-${testId}`;
            resultSection.innerHTML = `
                <h4>🔄 Probando: ${action}</h4>
                <p>Método: ${method}</p>
                <p>Estado: <span id="status-${testId}">Ejecutando...</span></p>
                <pre id="response-${testId}">Esperando respuesta...</pre>
            `;
            resultsDiv.appendChild(resultSection);

            try {
                // Construir URL relativa (corregida)
                let url = `modules/roles/actions.php?action=${action}`;
                
                // Agregar parámetros de prueba según la acción
                if (action === 'get_role_details' || action === 'get_users') {
                    url += '&role_id=1'; // Usar rol admin como ejemplo
                }

                const options = {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json'
                    }
                };

                if (data && method === 'POST') {
                    options.body = JSON.stringify(data);
                }

                console.log('🌐 Haciendo petición a:', url);
                
                const response = await fetch(url, options);
                const responseText = await response.text();
                
                document.getElementById(`status-${testId}`).textContent = `${response.status} ${response.statusText}`;
                document.getElementById(`response-${testId}`).textContent = responseText;

                // Verificar si es JSON válido
                try {
                    const jsonData = JSON.parse(responseText);
                    resultSection.className = 'test-section success';
                    document.getElementById(`status-${testId}`).textContent += ' ✅ JSON Válido';
                } catch (e) {
                    resultSection.className = 'test-section error';
                    document.getElementById(`status-${testId}`).textContent += ' ❌ No es JSON válido';
                }

            } catch (error) {
                document.getElementById(`status-${testId}`).textContent = `❌ Error: ${error.message}`;
                document.getElementById(`response-${testId}`).textContent = error.stack || error.message;
                resultSection.className = 'test-section error';
            }
        }

        async function testCreateRole() {
            const data = {
                name: 'test_role_' + Date.now(),
                display_name: 'Rol de Prueba',
                description: 'Rol creado para testing'
            };
            
            await testEndpoint('create', 'POST', data);
        }

        async function testUpdatePermissions() {
            const data = {
                role_id: 1,
                permissions: [1, 2, 3] // IDs de permisos de ejemplo
            };
            
            await testEndpoint('update_permissions', 'POST', data);
        }

        // Test automático al cargar la página
        window.onload = function() {
            console.log('🚀 Iniciando tests automáticos...');
            
            setTimeout(() => {
                testEndpoint('get_role_details', 'GET');
            }, 1000);
            
            setTimeout(() => {
                testEndpoint('get_users', 'GET');
            }, 2000);
        };
    </script>

    <div class="test-section info">
        <h3>📝 Notas</h3>
        <ul>
            <li><strong>Rutas corregidas:</strong> De <code>/modules/roles/actions.php</code> a <code>actions.php</code></li>
            <li><strong>Beneficio:</strong> Las rutas relativas funcionan tanto en desarrollo como en producción</li>
            <li><strong>Archivos modificados:</strong> <code>modules/roles/index.php</code></li>
            <li><strong>Total de correcciones:</strong> 6 rutas AJAX corregidas</li>
        </ul>
    </div>
</body>
</html>